/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import java.net.URI;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedParameters;
import org.opentripplanner.transit.model.site.StopTransferPriority;

public class GtfsFeedParametersBuilder {
    private URI source;
    private String feedId;
    private boolean removeRepeatedStops;
    private StopTransferPriority stationTransferPreference;
    private boolean discardMinTransferTimes;
    private boolean blockBasedInterlining;
    private int maxInterlineDistance;

    public GtfsFeedParametersBuilder() {
        this.removeRepeatedStops = true;
        this.stationTransferPreference = GtfsFeedParameters.DEFAULT_STATION_TRANSFER_PREFERENCE;
        this.discardMinTransferTimes = false;
        this.blockBasedInterlining = true;
        this.maxInterlineDistance = 200;
    }

    public GtfsFeedParametersBuilder(GtfsFeedParameters original) {
        this.removeRepeatedStops = original.removeRepeatedStops();
        this.stationTransferPreference = original.stationTransferPreference();
        this.discardMinTransferTimes = original.discardMinTransferTimes();
        this.blockBasedInterlining = original.blockBasedInterlining();
        this.maxInterlineDistance = original.maxInterlineDistance();
    }

    public GtfsFeedParametersBuilder withFeedId(String feedId) {
        this.feedId = feedId;
        return this;
    }

    String feedId() {
        return this.feedId;
    }

    public GtfsFeedParametersBuilder withStationTransferPreference(StopTransferPriority stationTransferPreference) {
        this.stationTransferPreference = stationTransferPreference;
        return this;
    }

    StopTransferPriority stationTransferPreference() {
        return this.stationTransferPreference;
    }

    public GtfsFeedParametersBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    URI source() {
        return this.source;
    }

    public GtfsFeedParametersBuilder withRemoveRepeatedStops(boolean value) {
        this.removeRepeatedStops = value;
        return this;
    }

    boolean removeRepeatedStops() {
        return this.removeRepeatedStops;
    }

    public GtfsFeedParametersBuilder withDiscardMinTransferTimes(boolean value) {
        this.discardMinTransferTimes = value;
        return this;
    }

    boolean discardMinTransferTimes() {
        return this.discardMinTransferTimes;
    }

    public GtfsFeedParametersBuilder withBlockBasedInterlining(boolean value) {
        this.blockBasedInterlining = value;
        return this;
    }

    boolean blockBasedInterlining() {
        return this.blockBasedInterlining;
    }

    public GtfsFeedParametersBuilder withMaxInterlineDistance(int value) {
        this.maxInterlineDistance = value;
        return this;
    }

    int maxInterlineDistance() {
        return this.maxInterlineDistance;
    }

    public GtfsFeedParameters build() {
        return new GtfsFeedParameters(this);
    }
}

