/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.TripDegenerate;
import org.opentripplanner.graph_builder.issues.TripUndefinedService;
import org.opentripplanner.graph_builder.module.geometry.GeometryProcessor;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTripPatternsOperation {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateTripPatternsOperation.class);
    private final Map<String, Integer> tripPatternIdCounters = new HashMap<String, Integer>();
    private final OtpTransitServiceBuilder transitDaoBuilder;
    private final DataImportIssueStore issueStore;
    private final Deduplicator deduplicator;
    private final Set<FeedScopedId> calendarServiceIds;
    private GeometryProcessor geometryProcessor;
    private final Multimap<StopPattern, TripPattern> tripPatterns;
    private final ListMultimap<Trip, Frequency> frequenciesForTrip = ArrayListMultimap.create();
    private int tripCount = 0;
    private int freqCount = 0;
    private int scheduledCount = 0;

    public GenerateTripPatternsOperation(OtpTransitServiceBuilder builder, DataImportIssueStore issueStore, Deduplicator deduplicator, Set<FeedScopedId> calendarServiceIds, GeometryProcessor geometryProcessor) {
        this.transitDaoBuilder = builder;
        this.issueStore = issueStore;
        this.deduplicator = deduplicator;
        this.calendarServiceIds = calendarServiceIds;
        this.geometryProcessor = geometryProcessor;
        this.tripPatterns = this.transitDaoBuilder.getTripPatterns();
    }

    public void run() {
        this.collectFrequencyByTrip();
        Collection<Trip> trips = this.transitDaoBuilder.getTripsById().values();
        int tripsSize = trips.size();
        for (Trip trip : trips) {
            if (++this.tripCount % 100000 == 0) {
                LOG.debug("build trip patterns {}/{}", (Object)this.tripCount, (Object)tripsSize);
            }
            this.buildTripPatternForTrip(trip);
        }
        LOG.info("Added {} frequency-based and {} single-trip timetable entries.", (Object)this.freqCount, (Object)this.scheduledCount);
    }

    public boolean hasFrequencyBasedTrips() {
        return this.freqCount > 0;
    }

    public boolean hasScheduledTrips() {
        return this.scheduledCount > 0;
    }

    private void collectFrequencyByTrip() {
        for (Frequency freq : this.transitDaoBuilder.getFrequencies()) {
            this.frequenciesForTrip.put((Object)freq.getTrip(), (Object)freq);
        }
    }

    private void buildTripPatternForTrip(Trip trip) {
        boolean flexTripWithZeroStops;
        if (!this.calendarServiceIds.contains(trip.getServiceId())) {
            this.issueStore.add(new TripUndefinedService(trip));
            return;
        }
        List<StopTime> stopTimes = this.transitDaoBuilder.getStopTimesSortedByTrip().get(trip);
        boolean staticTripWithFewerThan2Stops = !FlexTrip.containsFlexStops(stopTimes) && stopTimes.size() < 2;
        boolean bl = flexTripWithZeroStops = FlexTrip.containsFlexStops(stopTimes) && stopTimes.size() < 1;
        if (staticTripWithFewerThan2Stops || flexTripWithZeroStops) {
            this.issueStore.add(new TripDegenerate(trip));
            return;
        }
        StopPattern stopPattern = new StopPattern(stopTimes);
        Direction direction = trip.getDirection();
        TripPattern tripPattern = this.findOrCreateTripPattern(stopPattern, trip, direction);
        TripTimes tripTimes = new TripTimes(trip, stopTimes, this.deduplicator);
        List frequencies = this.frequenciesForTrip.get((Object)trip);
        if (!frequencies.isEmpty()) {
            for (Frequency freq : frequencies) {
                tripPattern.add(new FrequencyEntry(freq, tripTimes));
                ++this.freqCount;
            }
        } else {
            tripPattern.add(tripTimes);
            ++this.scheduledCount;
        }
    }

    private TripPattern findOrCreateTripPattern(StopPattern stopPattern, Trip trip, Direction direction) {
        TripPattern tripPattern2;
        Route route = trip.getRoute();
        for (TripPattern tripPattern2 : this.tripPatterns.get((Object)stopPattern)) {
            if (!tripPattern2.getRoute().equals(route) || !tripPattern2.getDirection().equals((Object)direction) || !tripPattern2.getMode().equals((Object)trip.getMode()) || !tripPattern2.getNetexSubmode().equals(trip.getNetexSubMode())) continue;
            return tripPattern2;
        }
        FeedScopedId patternId = this.generateUniqueIdForTripPattern(route, direction);
        tripPattern2 = (TripPattern)TripPattern.of(patternId).withRoute(route).withStopPattern(stopPattern).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withHopGeometries(this.geometryProcessor.createHopGeometries(trip)).build();
        this.tripPatterns.put((Object)stopPattern, (Object)tripPattern2);
        return tripPattern2;
    }

    private FeedScopedId generateUniqueIdForTripPattern(Route route, Direction direction) {
        FeedScopedId routeId = route.getId();
        String directionId = direction == Direction.UNKNOWN ? "" : Integer.toString(direction.gtfsCode);
        String key = routeId.getId() + ":" + direction;
        int counter = this.tripPatternIdCounters.getOrDefault(key, 0) + 1;
        this.tripPatternIdCounters.put(key, counter);
        String id = String.format("%s:%s:%02d", routeId.getId(), directionId, counter);
        return new FeedScopedId(routeId.getFeedId(), id);
    }
}

