/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.parameters;

import java.net.URI;
import java.time.ZoneId;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.openstreetmap.tagmapping.OsmTagMapperSource;

public class OsmExtractParametersBuilder {
    private URI source;
    private OsmTagMapperSource osmTagMapper;
    private ZoneId timeZone;

    public OsmExtractParametersBuilder() {
        this.osmTagMapper = OsmExtractParameters.DEFAULT_OSM_TAG_MAPPER;
        this.timeZone = OsmExtractParameters.DEFAULT_TIME_ZONE;
    }

    public OsmExtractParametersBuilder(OsmExtractParameters original) {
        this.osmTagMapper = original.osmTagMapper();
        this.timeZone = original.timeZone();
    }

    public OsmExtractParametersBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    public OsmExtractParametersBuilder withOsmTagMapper(OsmTagMapperSource mapper) {
        this.osmTagMapper = mapper;
        return this;
    }

    public OsmExtractParametersBuilder withTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public URI getSource() {
        return this.source;
    }

    public OsmTagMapperSource getOsmTagMapper() {
        return this.osmTagMapper;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public OsmExtractParameters build() {
        return new OsmExtractParameters(this);
    }
}

