/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import gnu.trove.TLongCollection;
import gnu.trove.list.TLongList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.DisconnectedOsmNode;
import org.opentripplanner.graph_builder.issues.InvalidOsmGeometry;
import org.opentripplanner.graph_builder.issues.LevelAmbiguous;
import org.opentripplanner.graph_builder.issues.PublicTransportRelationSkipped;
import org.opentripplanner.graph_builder.issues.TooManyAreasInRelation;
import org.opentripplanner.graph_builder.issues.TurnRestrictionBad;
import org.opentripplanner.graph_builder.issues.TurnRestrictionException;
import org.opentripplanner.graph_builder.issues.TurnRestrictionUnknown;
import org.opentripplanner.graph_builder.module.osm.Area;
import org.opentripplanner.graph_builder.module.osm.OSMFilter;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.openstreetmap.model.OSMLevel;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMRelation;
import org.opentripplanner.openstreetmap.model.OSMRelationMember;
import org.opentripplanner.openstreetmap.model.OSMTag;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.street.model.RepeatingTimePeriod;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.TurnRestrictionType;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMDatabase
implements org.opentripplanner.openstreetmap.spi.OSMDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(OSMDatabase.class);
    private final DataImportIssueStore issueStore;
    private final TLongObjectMap<OSMNode> nodesById = new TLongObjectHashMap();
    private final TLongObjectMap<OSMNode> bikeParkingNodes = new TLongObjectHashMap();
    private final TLongObjectMap<OSMNode> carParkingNodes = new TLongObjectHashMap();
    private final TLongObjectMap<OSMWay> waysById = new TLongObjectHashMap();
    private final TLongObjectMap<OSMWay> areaWaysById = new TLongObjectHashMap();
    private final TLongObjectMap<OSMRelation> relationsById = new TLongObjectHashMap();
    private final List<Area> walkableAreas = new ArrayList<Area>();
    private final List<Area> parkAndRideAreas = new ArrayList<Area>();
    private final List<Area> bikeParkingAreas = new ArrayList<Area>();
    private final TLongObjectMap<Set<OSMWay>> areasForNode = new TLongObjectHashMap();
    private final List<OSMWay> singleWayAreas = new ArrayList<OSMWay>();
    private final Set<OSMWithTags> processedAreas = new HashSet<OSMWithTags>();
    private final TLongSet areaWayIds = new TLongHashSet();
    private final TLongSet waysNodeIds = new TLongHashSet();
    private final TLongSet areaNodeIds = new TLongHashSet();
    private final Map<OSMWithTags, OSMLevel> wayLevels = new HashMap<OSMWithTags, OSMLevel>();
    private final Multimap<Long, TurnRestrictionTag> turnRestrictionsByFromWay = ArrayListMultimap.create();
    private final Multimap<Long, TurnRestrictionTag> turnRestrictionsByToWay = ArrayListMultimap.create();
    private final Map<OSMWithTags, Set<OSMNode>> stopsInAreas = new HashMap<OSMWithTags, Set<OSMNode>>();
    private long virtualNodeId = -100000L;
    public boolean noZeroLevels = true;
    private final Set<String> boardingAreaRefTags;

    public OSMDatabase(DataImportIssueStore issueStore, Set<String> boardingAreaRefTags) {
        this.issueStore = issueStore;
        this.boardingAreaRefTags = boardingAreaRefTags;
    }

    public OSMNode getNode(Long nodeId) {
        return (OSMNode)this.nodesById.get(nodeId.longValue());
    }

    public OSMWay getWay(Long nodeId) {
        return (OSMWay)this.waysById.get(nodeId.longValue());
    }

    public Collection<OSMWay> getWays() {
        return Collections.unmodifiableCollection(this.waysById.valueCollection());
    }

    public boolean isAreaWay(Long wayId) {
        return this.areaWayIds.contains(wayId.longValue());
    }

    public int nodeCount() {
        return this.nodesById.size();
    }

    public int wayCount() {
        return this.waysById.size();
    }

    public Collection<OSMNode> getBikeParkingNodes() {
        return Collections.unmodifiableCollection(this.bikeParkingNodes.valueCollection());
    }

    public Collection<OSMNode> getCarParkingNodes() {
        return Collections.unmodifiableCollection(this.carParkingNodes.valueCollection());
    }

    public Collection<Area> getWalkableAreas() {
        return Collections.unmodifiableCollection(this.walkableAreas);
    }

    public Collection<Area> getParkAndRideAreas() {
        return Collections.unmodifiableCollection(this.parkAndRideAreas);
    }

    public Collection<Area> getBikeParkingAreas() {
        return Collections.unmodifiableCollection(this.bikeParkingAreas);
    }

    public Collection<Long> getTurnRestrictionWayIds() {
        return Collections.unmodifiableCollection(this.turnRestrictionsByFromWay.keySet());
    }

    public Collection<TurnRestrictionTag> getFromWayTurnRestrictions(Long fromWayId) {
        return this.turnRestrictionsByFromWay.get((Object)fromWayId);
    }

    public Collection<TurnRestrictionTag> getToWayTurnRestrictions(Long toWayId) {
        return this.turnRestrictionsByToWay.get((Object)toWayId);
    }

    public Collection<OSMNode> getStopsInArea(OSMWithTags areaParent) {
        return this.stopsInAreas.get(areaParent);
    }

    public OSMLevel getLevelForWay(OSMWithTags way) {
        return Objects.requireNonNullElse(this.wayLevels.get(way), OSMLevel.DEFAULT);
    }

    public Set<OSMWay> getAreasForNode(Long nodeId) {
        Set areas = (Set)this.areasForNode.get(nodeId.longValue());
        if (areas == null) {
            return Set.of();
        }
        return areas;
    }

    public boolean isNodeBelongsToWay(Long nodeId) {
        return this.waysNodeIds.contains(nodeId.longValue());
    }

    @Override
    public void addNode(OSMNode node) {
        if (node.isBikeParking()) {
            this.bikeParkingNodes.put(node.getId(), (Object)node);
        }
        if (node.isParkAndRide()) {
            this.carParkingNodes.put(node.getId(), (Object)node);
        }
        if (!(this.waysNodeIds.contains(node.getId()) || this.areaNodeIds.contains(node.getId()) || node.isBoardingLocation())) {
            return;
        }
        if (this.nodesById.containsKey(node.getId())) {
            return;
        }
        this.nodesById.put(node.getId(), (Object)node);
    }

    @Override
    public void addWay(OSMWay way) {
        long wayId = way.getId();
        if (this.waysById.containsKey(wayId) || this.areaWaysById.containsKey(wayId)) {
            return;
        }
        if (this.areaWayIds.contains(wayId)) {
            this.areaWaysById.put(wayId, (Object)way);
        }
        if (!(OSMFilter.isWayRoutable(way) || way.isParkAndRide() || way.isBikeParking() || way.isBoardingLocation())) {
            return;
        }
        this.applyLevelsForWay(way);
        if ((way.isTag("area", "yes").booleanValue() || way.isTag("amenity", "parking").booleanValue() || way.isTag("amenity", "bicycle_parking").booleanValue() || way.isBoardingArea()) && way.getNodeRefs().size() > 2) {
            if (!this.areaWayIds.contains(wayId)) {
                this.singleWayAreas.add(way);
                this.areaWaysById.put(wayId, (Object)way);
                this.areaWayIds.add(wayId);
                way.getNodeRefs().forEach(node -> {
                    MapUtils.addToMapSet(this.areasForNode, node, way);
                    return true;
                });
            }
            return;
        }
        this.waysById.put(wayId, (Object)way);
    }

    @Override
    public void addRelation(OSMRelation relation) {
        if (this.relationsById.containsKey(relation.getId())) {
            return;
        }
        if (relation.isTag("type", "multipolygon").booleanValue() && (OSMFilter.isOsmEntityRoutable(relation) || relation.isParkAndRide()) || relation.isBikeParking()) {
            if (!(OSMFilter.isWayRoutable(relation) || relation.isParkAndRide() || relation.isBikeParking())) {
                return;
            }
            for (OSMRelationMember member : relation.getMembers()) {
                this.areaWayIds.add(member.getRef());
            }
            this.applyLevelsForWay(relation);
        } else if (!(relation.isTag("type", "restriction").booleanValue() || relation.isTag("type", "route").booleanValue() && relation.isTag("route", "road").booleanValue() || relation.isTag("type", "multipolygon").booleanValue() && OSMFilter.isOsmEntityRoutable(relation) || relation.isTag("type", "level_map").booleanValue() || relation.isTag("type", "public_transport").booleanValue() && relation.isTag("public_transport", "stop_area").booleanValue() || relation.isTag("type", "route").booleanValue() && (relation.isTag("route", "road").booleanValue() || relation.isTag("route", "bicycle").booleanValue()))) {
            return;
        }
        this.relationsById.put(relation.getId(), (Object)relation);
    }

    @Override
    public void doneFirstPhaseRelations() {
    }

    @Override
    public void doneSecondPhaseWays() {
        this.markNodesForKeeping(this.waysById.valueCollection(), this.waysNodeIds);
        this.markNodesForKeeping(this.areaWaysById.valueCollection(), this.areaNodeIds);
    }

    @Override
    public void doneThirdPhaseNodes() {
        this.processMultipolygonRelations();
        this.processSingleWayAreas();
    }

    public void postLoad() {
        this.processRelations();
        this.processUnconnectedAreas();
    }

    private static boolean checkIntersectionDistance(Point p, OSMNode n, double epsilon) {
        return Math.abs(p.getY() - n.lat) < epsilon && Math.abs(p.getX() - n.lon) < epsilon;
    }

    private static boolean checkDistanceWithin(OSMNode a, OSMNode b, double epsilon) {
        return Math.abs(a.lat - b.lat) < epsilon && Math.abs(a.lon - b.lon) < epsilon;
    }

    private void processUnconnectedAreas() {
        LOG.info("Intersecting unconnected areas...");
        HashSet<KeyPair> commonSegments = new HashSet<KeyPair>();
        HashGridSpatialIndex<RingSegment> spndx = new HashGridSpatialIndex<RingSegment>();
        for (Area area : Iterables.concat(this.parkAndRideAreas, this.bikeParkingAreas)) {
            for (Ring ring : area.outermostRings) {
                this.processAreaRingForUnconnectedAreas(commonSegments, spndx, area, ring);
            }
        }
        int nCreatedNodes = 0;
        for (OSMWay way : this.waysById.valueCollection()) {
            OSMLevel wayLevel = this.getLevelForWay(way);
            block3: for (int i = 0; i < way.getNodeRefs().size() - 1; ++i) {
                Envelope env;
                List<RingSegment> ringSegments;
                OSMNode nA = (OSMNode)this.nodesById.get(way.getNodeRefs().get(i));
                OSMNode nB = (OSMNode)this.nodesById.get(way.getNodeRefs().get(i + 1));
                if (nA == null || nB == null || (ringSegments = spndx.query(env = new Envelope(nA.lon, nB.lon, nA.lat, nB.lat))).size() == 0) continue;
                LineString seg = GeometryUtils.makeLineString(nA.lon, nA.lat, nB.lon, nB.lat);
                for (RingSegment ringSegment : ringSegments) {
                    OSMNode splitNode;
                    OSMLevel areaLevel;
                    boolean wayWasSplit = false;
                    if (ringSegment.nA.getId() == nA.getId() || ringSegment.nA.getId() == nB.getId() || ringSegment.nB.getId() == nA.getId() || ringSegment.nB.getId() == nB.getId() || !wayLevel.equals(areaLevel = this.getLevelForWay(ringSegment.area.parent))) continue;
                    LineString seg2 = GeometryUtils.makeLineString(ringSegment.nA.lon, ringSegment.nA.lat, ringSegment.nB.lon, ringSegment.nB.lat);
                    Geometry intersection = seg2.intersection((Geometry)seg);
                    Point p = null;
                    if (intersection.isEmpty()) continue;
                    if (!(intersection instanceof Point)) {
                        LOG.error("Alien intersection type between {} ({}--{}) and {} ({}--{}): {}", new Object[]{way, nA, nB, ringSegment.area.parent, ringSegment.nA, ringSegment.nB, intersection});
                        continue;
                    }
                    p = (Point)intersection;
                    double epsilon = 1.0E-7;
                    if (OSMDatabase.checkIntersectionDistance(p, nA, epsilon)) {
                        splitNode = nA;
                        if (ringSegment.ring.nodes.contains(splitNode)) continue;
                        if (OSMDatabase.checkDistanceWithin(ringSegment.nA, nA, epsilon) || OSMDatabase.checkDistanceWithin(ringSegment.nB, nA, epsilon)) {
                            this.issueStore.add(new DisconnectedOsmNode(nA, way, ringSegment.area.parent));
                        }
                    } else if (OSMDatabase.checkIntersectionDistance(p, nB, epsilon)) {
                        splitNode = nB;
                        if (ringSegment.ring.nodes.contains(splitNode)) continue;
                        if (OSMDatabase.checkDistanceWithin(ringSegment.nA, nB, epsilon) || OSMDatabase.checkDistanceWithin(ringSegment.nB, nB, epsilon)) {
                            this.issueStore.add(new DisconnectedOsmNode(nB, way, ringSegment.area.parent));
                        }
                    } else {
                        if (OSMDatabase.checkIntersectionDistance(p, ringSegment.nA, epsilon)) {
                            if (way.getNodeRefs().contains(ringSegment.nA.getId())) continue;
                            way.addNodeRef(ringSegment.nA.getId(), i + 1);
                            if (OSMDatabase.checkDistanceWithin(ringSegment.nA, nA, epsilon) || OSMDatabase.checkDistanceWithin(ringSegment.nA, nB, epsilon)) {
                                this.issueStore.add(new DisconnectedOsmNode(nB, ringSegment.area.parent, way));
                            }
                            --i;
                            continue block3;
                        }
                        if (OSMDatabase.checkIntersectionDistance(p, ringSegment.nB, epsilon)) {
                            if (way.getNodeRefs().contains(ringSegment.nB.getId())) continue;
                            way.addNodeRef(ringSegment.nB.getId(), i + 1);
                            if (OSMDatabase.checkDistanceWithin(ringSegment.nB, nA, epsilon) || OSMDatabase.checkDistanceWithin(ringSegment.nB, nB, epsilon)) {
                                this.issueStore.add(new DisconnectedOsmNode(ringSegment.nB, ringSegment.area.parent, way));
                            }
                            --i;
                            continue block3;
                        }
                        splitNode = this.createVirtualNode(p.getCoordinate());
                        ++nCreatedNodes;
                        LOG.debug("Adding virtual {}, intersection of {} ({}--{}) and area {} ({}--{}) at {}.", new Object[]{splitNode, way, nA, nB, ringSegment.area.parent, ringSegment.nA, ringSegment.nB, p});
                        way.addNodeRef(splitNode.getId(), i + 1);
                        wayWasSplit = true;
                    }
                    int j = ringSegment.ring.nodes.indexOf(ringSegment.nB);
                    ringSegment.ring.nodes.add(j, splitNode);
                    RingSegment ringSegment2 = new RingSegment();
                    ringSegment2.area = ringSegment.area;
                    ringSegment2.ring = ringSegment.ring;
                    ringSegment2.nA = splitNode;
                    ringSegment2.nB = ringSegment.nB;
                    Envelope env2 = new Envelope(ringSegment2.nA.lon, ringSegment2.nB.lon, ringSegment2.nA.lat, ringSegment2.nB.lat);
                    spndx.insert(env2, (Object)ringSegment2);
                    ringSegment.nB = splitNode;
                    if (!wayWasSplit) continue;
                    --i;
                    continue block3;
                }
            }
        }
        LOG.info("Created {} virtual intersection nodes.", (Object)nCreatedNodes);
    }

    private void processAreaRingForUnconnectedAreas(Set<KeyPair> commonSegments, HashGridSpatialIndex<RingSegment> spndx, Area area, Ring ring) {
        for (int j = 0; j < ring.nodes.size(); ++j) {
            RingSegment ringSegment = new RingSegment();
            ringSegment.area = area;
            ringSegment.ring = ring;
            ringSegment.nA = ring.nodes.get(j);
            ringSegment.nB = ring.nodes.get((j + 1) % ring.nodes.size());
            Envelope env = new Envelope(ringSegment.nA.lon, ringSegment.nB.lon, ringSegment.nA.lat, ringSegment.nB.lat);
            KeyPair key1 = new KeyPair(ringSegment.nA.getId(), ringSegment.nB.getId());
            KeyPair key2 = new KeyPair(ringSegment.nB.getId(), ringSegment.nA.getId());
            if (commonSegments.contains(key1) || commonSegments.contains(key2)) continue;
            spndx.insert(env, (Object)ringSegment);
            commonSegments.add(key1);
            commonSegments.add(key2);
        }
        ring.getHoles().forEach(hole -> this.processAreaRingForUnconnectedAreas(commonSegments, spndx, area, (Ring)hole));
    }

    private OSMNode createVirtualNode(Coordinate c) {
        OSMNode node = new OSMNode();
        node.lon = c.x;
        node.lat = c.y;
        node.setId(this.virtualNodeId);
        --this.virtualNodeId;
        this.waysNodeIds.add(node.getId());
        this.nodesById.put(node.getId(), (Object)node);
        return node;
    }

    private void applyLevelsForWay(OSMWithTags way) {
        if (!this.wayLevels.containsKey(way)) {
            String levelName = null;
            OSMLevel level = OSMLevel.DEFAULT;
            if (way.hasTag("level")) {
                levelName = way.getTag("level");
                level = OSMLevel.fromString(levelName, OSMLevel.Source.LEVEL_TAG, this.noZeroLevels, this.issueStore);
            } else if (way.hasTag("layer")) {
                levelName = way.getTag("layer");
                level = OSMLevel.fromString(levelName, OSMLevel.Source.LAYER_TAG, this.noZeroLevels, this.issueStore);
            }
            if (level == null || !level.reliable) {
                this.issueStore.add(new LevelAmbiguous(levelName, way));
                level = OSMLevel.DEFAULT;
            }
            this.wayLevels.put(way, level);
        }
    }

    private void markNodesForKeeping(Collection<OSMWay> osmWays, TLongSet nodeSet) {
        for (OSMWay way : osmWays) {
            TLongList nodes = way.getNodeRefs();
            if (nodes.size() <= 1) continue;
            nodeSet.addAll((TLongCollection)nodes);
        }
    }

    private void processSingleWayAreas() {
        block3: for (OSMWay way : this.singleWayAreas) {
            if (this.processedAreas.contains(way)) continue;
            for (long nodeRef : way.getNodeRefs()) {
                if (this.nodesById.containsKey(nodeRef)) continue;
                continue block3;
            }
            try {
                this.newArea(new Area(way, List.of(way), Collections.emptyList(), this.nodesById));
            }
            catch (Area.AreaConstructionException | Ring.RingConstructionException e) {
                this.issueStore.add(new InvalidOsmGeometry(way));
            }
            catch (IllegalArgumentException iae) {
                this.issueStore.add(new InvalidOsmGeometry(way));
            }
            this.processedAreas.add(way);
        }
    }

    private void processMultipolygonRelations() {
        block2: for (OSMRelation relation : this.relationsById.valueCollection()) {
            if (this.processedAreas.contains(relation) || !relation.isTag("type", "multipolygon").booleanValue() || !OSMFilter.isOsmEntityRoutable(relation) && !relation.isParkAndRide() && !relation.isBikeParking()) continue;
            ArrayList<OSMWay> innerWays = new ArrayList<OSMWay>();
            ArrayList<OSMWay> outerWays = new ArrayList<OSMWay>();
            for (OSMRelationMember member : relation.getMembers()) {
                String role = member.getRole();
                OSMWay way = (OSMWay)this.areaWaysById.get(member.getRef());
                if (way == null) continue block2;
                for (long nodeId : way.getNodeRefs()) {
                    if (!this.nodesById.containsKey(nodeId)) continue block2;
                    MapUtils.addToMapSet(this.areasForNode, nodeId, way);
                }
                if (role.equals("inner")) {
                    innerWays.add(way);
                    continue;
                }
                if (role.equals("outer")) {
                    outerWays.add(way);
                    continue;
                }
                LOG.warn("Unexpected role {} in multipolygon", (Object)role);
            }
            this.processedAreas.add(relation);
            try {
                this.newArea(new Area(relation, outerWays, innerWays, this.nodesById));
            }
            catch (Area.AreaConstructionException | Ring.RingConstructionException e) {
                this.issueStore.add(new InvalidOsmGeometry(relation));
                continue;
            }
            for (OSMRelationMember member : relation.getMembers()) {
                String[] relationCopyTags;
                OSMWithTags way;
                if (!"way".equals(member.getType()) || !this.waysById.containsKey(member.getRef()) || (way = (OSMWithTags)this.waysById.get(member.getRef())) == null) continue;
                for (String tag : relationCopyTags = new String[]{"highway", "name", "ref"}) {
                    if (!relation.hasTag(tag) || way.hasTag(tag)) continue;
                    way.addTag(tag, relation.getTag(tag));
                }
                if (relation.isTag("railway", "platform").booleanValue() && !way.hasTag("railway")) {
                    way.addTag("railway", "platform");
                }
                if (!relation.isPlatform() || way.hasTag("public_transport")) continue;
                way.addTag("public_transport", "platform");
            }
        }
    }

    private void newArea(Area area) {
        StreetTraversalPermission permissions = OSMFilter.getPermissionsForEntity(area.parent, StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE);
        if (OSMFilter.isOsmEntityRoutable(area.parent) && permissions != StreetTraversalPermission.NONE) {
            this.walkableAreas.add(area);
        }
        if (area.parent.isParkAndRide()) {
            this.parkAndRideAreas.add(area);
        }
        if (area.parent.isBikeParking()) {
            this.bikeParkingAreas.add(area);
        }
    }

    private void processRelations() {
        LOG.debug("Processing relations...");
        for (OSMRelation relation : this.relationsById.valueCollection()) {
            if (relation.isTag("type", "restriction").booleanValue()) {
                this.processRestriction(relation);
                continue;
            }
            if (relation.isTag("type", "level_map").booleanValue()) {
                this.processLevelMap(relation);
                continue;
            }
            if (relation.isTag("type", "route").booleanValue()) {
                this.processRoad(relation);
                this.processBicycleRoute(relation);
                continue;
            }
            if (!relation.isTag("type", "public_transport").booleanValue()) continue;
            this.processPublicTransportStopArea(relation);
        }
    }

    private void processBicycleRoute(OSMRelation relation) {
        if (relation.isTag("route", "bicycle").booleanValue()) {
            String network = relation.getTag("network");
            if (network == null) {
                network = "lcn";
            }
            switch (network) {
                case "lcn": {
                    this.setNetworkForAllMembers(relation, "lcn");
                    break;
                }
                case "rcn": {
                    this.setNetworkForAllMembers(relation, "rcn");
                    break;
                }
                case "ncn": {
                    this.setNetworkForAllMembers(relation, "ncn");
                    break;
                }
                case "icn": {
                    this.setNetworkForAllMembers(relation, "icn");
                    break;
                }
                default: {
                    this.setNetworkForAllMembers(relation, "lcn");
                }
            }
        }
    }

    private void setNetworkForAllMembers(OSMRelation relation, String key) {
        relation.getMembers().forEach(member -> {
            boolean isOsmWay = "way".equals(member.getType());
            OSMWay way = (OSMWay)this.waysById.get(member.getRef());
            if (way != null && isOsmWay && !way.hasTag(key)) {
                way.addTag(key, "yes");
            }
        });
    }

    private void processRestriction(OSMRelation relation) {
        TurnRestrictionTag tag;
        long from = -1L;
        long to = -1L;
        long via = -1L;
        for (OSMRelationMember member : relation.getMembers()) {
            String[] role = member.getRole();
            if (role.equals("from")) {
                from = member.getRef();
                continue;
            }
            if (role.equals("to")) {
                to = member.getRef();
                continue;
            }
            if (!role.equals("via")) continue;
            via = member.getRef();
        }
        if (from == -1L || to == -1L || via == -1L) {
            this.issueStore.add(new TurnRestrictionBad(relation.getId(), "One of from|via|to edges are empty in relation"));
            return;
        }
        TraverseModeSet modes = new TraverseModeSet(TraverseMode.BICYCLE, TraverseMode.CAR);
        String exceptModes = relation.getTag("except");
        if (exceptModes != null) {
            for (String m : exceptModes.split(";")) {
                if (m.equals("motorcar")) {
                    modes.setCar(false);
                    continue;
                }
                if (!m.equals("bicycle")) continue;
                modes.setBicycle(false);
                this.issueStore.add(new TurnRestrictionException(via, from));
            }
        }
        if (relation.isTag("restriction", "no_right_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.RIGHT, relation.getId());
        } else if (relation.isTag("restriction", "no_left_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.LEFT, relation.getId());
        } else if (relation.isTag("restriction", "no_straight_on").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.STRAIGHT, relation.getId());
        } else if (relation.isTag("restriction", "no_u_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.U, relation.getId());
        } else if (relation.isTag("restriction", "only_straight_on").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.STRAIGHT, relation.getId());
        } else if (relation.isTag("restriction", "only_right_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.RIGHT, relation.getId());
        } else if (relation.isTag("restriction", "only_left_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.LEFT, relation.getId());
        } else if (relation.isTag("restriction", "only_u_turn").booleanValue()) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.U, relation.getId());
        } else {
            this.issueStore.add(new TurnRestrictionUnknown(relation, relation.getTag("restriction")));
            return;
        }
        tag.modes = modes.clone();
        if (relation.hasTag("day_on") && relation.hasTag("day_off") && relation.hasTag("hour_on") && relation.hasTag("hour_off")) {
            try {
                tag.time = RepeatingTimePeriod.parseFromOsmTurnRestriction(relation.getTag("day_on"), relation.getTag("day_off"), relation.getTag("hour_on"), relation.getTag("hour_off"), relation.getOsmProvider()::getZoneId);
            }
            catch (NumberFormatException e) {
                LOG.info("Unparseable turn restriction: {}", (Object)relation.getId());
            }
        }
        this.turnRestrictionsByFromWay.put((Object)from, (Object)tag);
        this.turnRestrictionsByToWay.put((Object)to, (Object)tag);
    }

    private void processLevelMap(OSMRelation relation) {
        Map<String, OSMLevel> levels = OSMLevel.mapFromSpecList(relation.getTag("levels"), OSMLevel.Source.LEVEL_MAP, true, this.issueStore);
        for (OSMRelationMember member : relation.getMembers()) {
            String role;
            OSMWay way;
            if (!"way".equals(member.getType()) || !this.waysById.containsKey(member.getRef()) || (way = (OSMWay)this.waysById.get(member.getRef())) == null || relation.hasTag("role:" + (role = member.getRole()))) continue;
            if (levels.containsKey(role)) {
                this.wayLevels.put(way, levels.get(role));
                continue;
            }
            LOG.warn("{} has undefined level {}", (Object)member.getRef(), (Object)role);
        }
    }

    private void processRoad(OSMRelation relation) {
        for (OSMRelationMember member : relation.getMembers()) {
            OSMWithTags way;
            if (!"way".equals(member.getType()) || !this.waysById.containsKey(member.getRef()) || (way = (OSMWithTags)this.waysById.get(member.getRef())) == null) continue;
            if (relation.hasTag("name")) {
                if (way.hasTag("otp:route_name")) {
                    way.addTag("otp:route_name", this.addUniqueName(way.getTag("otp:route_name"), relation.getTag("name")));
                } else {
                    way.addTag(new OSMTag("otp:route_name", relation.getTag("name")));
                }
            }
            if (!relation.hasTag("ref")) continue;
            if (way.hasTag("otp:route_ref")) {
                way.addTag("otp:route_ref", this.addUniqueName(way.getTag("otp:route_ref"), relation.getTag("ref")));
                continue;
            }
            way.addTag(new OSMTag("otp:route_ref", relation.getTag("ref")));
        }
    }

    private void processPublicTransportStopArea(OSMRelation relation) {
        OSMWithTags platformArea = null;
        HashSet<OSMNode> platformsNodes = new HashSet<OSMNode>();
        for (OSMRelationMember member : relation.getMembers()) {
            if ("way".equals(member.getType()) && "platform".equals(member.getRole()) && this.areaWayIds.contains(member.getRef())) {
                if (platformArea == null) {
                    platformArea = (OSMWithTags)this.areaWaysById.get(member.getRef());
                    continue;
                }
                this.issueStore.add(new TooManyAreasInRelation(relation));
                continue;
            }
            if ("relation".equals(member.getType()) && "platform".equals(member.getRole()) && this.relationsById.containsKey(member.getRef())) {
                if (platformArea == null) {
                    platformArea = (OSMWithTags)this.relationsById.get(member.getRef());
                    continue;
                }
                this.issueStore.add(new TooManyAreasInRelation(relation));
                continue;
            }
            if (!"node".equals(member.getType()) || !this.nodesById.containsKey(member.getRef())) continue;
            platformsNodes.add((OSMNode)this.nodesById.get(member.getRef()));
        }
        if (platformArea != null && !platformsNodes.isEmpty()) {
            this.stopsInAreas.put(platformArea, platformsNodes);
        } else {
            this.issueStore.add(new PublicTransportRelationSkipped(relation));
        }
    }

    private String addUniqueName(String routes, String name) {
        String[] names;
        for (String existing : names = routes.split(", ")) {
            if (!existing.equals(name)) continue;
            return routes;
        }
        return routes + ", " + name;
    }

    static class RingSegment {
        Area area;
        Ring ring;
        OSMNode nA;
        OSMNode nB;

        RingSegment() {
        }
    }

    private record KeyPair(long id0, long id1) {
    }
}

