/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import gnu.trove.list.TLongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.openstreetmap.model.OSMLevel;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.ElevatorAlightEdge;
import org.opentripplanner.street.model.edge.ElevatorBoardEdge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.edge.FreeEdge;
import org.opentripplanner.street.model.vertex.ElevatorOffboardVertex;
import org.opentripplanner.street.model.vertex.ElevatorOnboardVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElevatorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ElevatorProcessor.class);
    private final DataImportIssueStore issueStore;
    private final Map<Long, Map<OSMLevel, OsmVertex>> multiLevelNodes;
    private final OSMDatabase osmdb;
    private final Map<Long, IntersectionVertex> intersectionNodes;

    public ElevatorProcessor(DataImportIssueStore issueStore, OSMDatabase osmdb, Map<Long, Map<OSMLevel, OsmVertex>> multiLevelNodes, Map<Long, IntersectionVertex> intersectionNodes) {
        this.issueStore = issueStore;
        this.osmdb = osmdb;
        this.multiLevelNodes = multiLevelNodes;
        this.intersectionNodes = intersectionNodes;
    }

    public void buildElevatorEdges(Graph graph) {
        for (Long nodeId : this.multiLevelNodes.keySet()) {
            OSMNode node = this.osmdb.getNode(nodeId);
            Map<OSMLevel, OsmVertex> vertices = this.multiLevelNodes.get(nodeId);
            Object[] levels = vertices.keySet().toArray(new OSMLevel[0]);
            Arrays.sort(levels);
            ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
            for (Object level : levels) {
                OsmVertex sourceVertex = vertices.get(level);
                String sourceVertexLabel = sourceVertex.getLabel();
                String levelName = ((OSMLevel)level).longName;
                ElevatorProcessor.createElevatorVertices(graph, onboardVertices, sourceVertex, sourceVertexLabel, levelName);
            }
            int travelTime = this.parseDuration(node).orElse(-1);
            Accessibility wheelchair = node.getWheelchairAccessibility();
            ElevatorProcessor.createElevatorHopEdges(onboardVertices, wheelchair, node.isTagTrue("bicycle"), levels.length, travelTime);
        }
        Iterator elevators = this.osmdb.getWays().stream().filter(this::isElevatorWay).iterator();
        while (elevators.hasNext()) {
            OSMWay elevatorWay = (OSMWay)elevators.next();
            List<Long> nodes = Arrays.stream(elevatorWay.getNodeRefs().toArray()).filter(nodeRef -> this.intersectionNodes.containsKey(nodeRef) && this.intersectionNodes.get(nodeRef) != null).boxed().toList();
            ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
            for (int i = 0; i < nodes.size(); ++i) {
                Long node = nodes.get(i);
                IntersectionVertex sourceVertex = this.intersectionNodes.get(node);
                String sourceVertexLabel = sourceVertex.getLabel();
                String levelName = elevatorWay.getId() + " / " + i;
                ElevatorProcessor.createElevatorVertices(graph, onboardVertices, sourceVertex, elevatorWay.getId() + "_" + sourceVertexLabel, levelName);
            }
            int travelTime = this.parseDuration(elevatorWay).orElse(-1);
            int levels = nodes.size();
            Accessibility wheelchair = elevatorWay.getWheelchairAccessibility();
            ElevatorProcessor.createElevatorHopEdges(onboardVertices, wheelchair, elevatorWay.isTagTrue("bicycle"), levels, travelTime);
            LOG.debug("Created elevatorHopEdges for way {}", (Object)elevatorWay.getId());
        }
    }

    private static void createElevatorVertices(Graph graph, ArrayList<Vertex> onboardVertices, IntersectionVertex sourceVertex, String sourceVertexLabel, String levelName) {
        ElevatorOffboardVertex offboardVertex = new ElevatorOffboardVertex(graph, sourceVertexLabel + "_offboard", sourceVertex.getX(), sourceVertex.getY(), new NonLocalizedString(levelName));
        new FreeEdge(sourceVertex, offboardVertex);
        new FreeEdge(offboardVertex, sourceVertex);
        ElevatorOnboardVertex onboardVertex = new ElevatorOnboardVertex(graph, sourceVertexLabel + "_onboard", sourceVertex.getX(), sourceVertex.getY(), new NonLocalizedString(levelName));
        new ElevatorBoardEdge(offboardVertex, onboardVertex);
        new ElevatorAlightEdge(onboardVertex, offboardVertex, new NonLocalizedString(levelName));
        onboardVertices.add(onboardVertex);
    }

    private static void createElevatorHopEdges(ArrayList<Vertex> onboardVertices, Accessibility wheelchair, boolean bicycleAllowed, int levels, int travelTime) {
        int vSize = onboardVertices.size() - 1;
        for (int i = 0; i < vSize; ++i) {
            StreetTraversalPermission permission;
            Vertex from = onboardVertices.get(i);
            Vertex to = onboardVertices.get(i + 1);
            StreetTraversalPermission streetTraversalPermission = permission = bicycleAllowed ? StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE : StreetTraversalPermission.PEDESTRIAN;
            if (travelTime > -1 && levels > 0) {
                ElevatorHopEdge.bidirectional(from, to, permission, wheelchair, levels, travelTime);
                continue;
            }
            ElevatorHopEdge.bidirectional(from, to, permission, wheelchair);
        }
    }

    private boolean isElevatorWay(OSMWay way) {
        if (!way.hasTag("highway")) {
            return false;
        }
        if (!"elevator".equals(way.getTag("highway"))) {
            return false;
        }
        if (this.osmdb.isAreaWay(way.getId())) {
            return false;
        }
        TLongList nodeRefs = way.getNodeRefs();
        return nodeRefs.get(0) != nodeRefs.get(nodeRefs.size() - 1);
    }

    private OptionalInt parseDuration(OSMWithTags element) {
        return element.getTagAsInt("duration", v -> this.issueStore.add(Issue.issue("InvalidDuration", "Duration for osm node %d is not a number: '%s'; it's replaced with '-1' (unknown).", element.getId(), v)));
    }
}

