/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opentripplanner.framework.collection.MapUtils;

public class DisjointSet<T> {
    TIntList sets = new TIntArrayList();
    TObjectIntMap<T> setMapping = new TObjectIntHashMap();

    public int union(T element1, T element2) {
        int p2;
        int p1 = this.find(element1);
        if (p1 == (p2 = this.find(element2))) {
            return p1;
        }
        int p1size = -this.sets.get(p1);
        int p2size = -this.sets.get(p2);
        int totalSize = p1size + p2size;
        if (p1size > p2size) {
            this.sets.set(p2, p1);
            this.sets.set(p1, -totalSize);
            return p2;
        }
        this.sets.set(p1, p2);
        this.sets.set(p2, -totalSize);
        return p1;
    }

    public int find(T element) {
        if (this.setMapping.containsKey(element)) {
            int i = this.setMapping.get(element);
            return this.compact(i);
        }
        this.setMapping.put(element, this.sets.size());
        this.sets.add(-1);
        return this.sets.size() - 1;
    }

    public boolean exists(T element) {
        return this.setMapping.containsKey(element);
    }

    public List<Set<T>> sets() {
        TLongObjectHashMap out = new TLongObjectHashMap();
        this.setMapping.forEachEntry((arg_0, arg_1) -> this.lambda$sets$0((TLongObjectMap)out, arg_0, arg_1));
        return new ArrayList<Set<T>>(out.valueCollection());
    }

    public int size(int component) {
        return -this.sets.get(component);
    }

    private int compact(int i) {
        int key = this.sets.get(i);
        if (key < 0) {
            return i;
        }
        int j = this.compact(key);
        this.sets.set(i, j);
        return j;
    }

    private /* synthetic */ boolean lambda$sets$0(TLongObjectMap out, Object k, int v) {
        MapUtils.addToMapSet(out, this.compact(v), k);
        return true;
    }
}

