/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.module.osm.AreaGroup;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public record AreaTooComplicated(AreaGroup areaGroup, int nbNodes, int maxAreaNodes) implements DataImportIssue
{
    private static final String FMT = "Area %s is too complicated (%s > %s)";
    private static final String HTMLFMT = "Area <a href='%s'>'%s'</a> is too complicated (%s > %s)";

    @Override
    public String getMessage() {
        return String.format(FMT, this.areaGroup.getSomeOSMObject().getId(), this.nbNodes, this.maxAreaNodes);
    }

    @Override
    public String getHTMLMessage() {
        OSMWithTags entity = this.areaGroup.getSomeOSMObject();
        return String.format(HTMLFMT, entity.getOpenStreetMapLink(), entity.getId(), this.nbNodes, this.maxAreaNodes);
    }

    @Override
    public int getPriority() {
        return this.nbNodes;
    }

    @Override
    public Geometry getGeometry() {
        return this.areaGroup.union;
    }
}

