/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import java.util.ArrayList;
import java.util.List;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opentripplanner.graph_builder.module.ned.VerticalDatum;

public class UnifiedGridCoverage
extends AbstractCoverage {
    private final SpatialIndex datumRegionIndex;
    private final ArrayList<Coverage> regions = new ArrayList();

    protected UnifiedGridCoverage(List<GridCoverage2D> regionCoverages, List<VerticalDatum> datums) {
        super((CharSequence)"unified", (Coverage)regionCoverages.get(0));
        this.datumRegionIndex = new STRtree();
        for (GridCoverage2D regionCoverage : regionCoverages) {
            GridCoverage2D regionCoverageInterpolator = Interpolator2D.create((GridCoverage2D)regionCoverage, (Interpolation)new InterpolationBilinear());
            for (VerticalDatum datum : datums) {
                Envelope datumEnvelope = new Envelope(datum.lowerLeftLongitude, datum.lowerLeftLongitude + datum.deltaLongitude, datum.lowerLeftLatitude, datum.lowerLeftLatitude + datum.deltaLatitude);
                ReferencedEnvelope regionEnvelope = new ReferencedEnvelope(regionCoverageInterpolator.getEnvelope());
                ReferencedEnvelope intersection = regionEnvelope.intersection(datumEnvelope);
                this.datumRegionIndex.insert((Envelope)intersection, (Object)new DatumRegion(datum, (Coverage)regionCoverageInterpolator));
            }
            this.regions.add((Coverage)regionCoverageInterpolator);
        }
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        return null;
    }

    public int getNumSampleDimensions() {
        return this.regions.get(0).getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.regions.get(0).getSampleDimension(index);
    }

    public double[] evaluate(DirectPosition point, double[] values) throws CannotEvaluateException {
        double y;
        double x = point.getOrdinate(0);
        Coordinate pointCoordinate = new Coordinate(x, y = point.getOrdinate(1));
        Envelope envelope = new Envelope(pointCoordinate);
        List coverageCandidates = this.datumRegionIndex.query(envelope);
        if (coverageCandidates.size() > 0) {
            DatumRegion datumRegion = (DatumRegion)coverageCandidates.get(0);
            double[] result = datumRegion.region.evaluate(point, values);
            result[0] = result[0] + datumRegion.datum.interpolatedHeight(x, y);
            return result;
        }
        throw new PointOutsideCoverageException("Point not found: " + point);
    }

    public static class DatumRegion {
        public final VerticalDatum datum;
        public final Coverage region;

        public DatumRegion(VerticalDatum datum, Coverage region) {
            this.datum = datum;
            this.region = region;
        }
    }
}

