/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public class NoDataGridCoverage
implements GridCoverage {
    private final GridCoverage2D gridCoverage;
    private final NoDataContainer noData;

    private NoDataGridCoverage(GridCoverage2D gridCoverage) {
        this.gridCoverage = gridCoverage;
        this.noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)gridCoverage);
    }

    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    public Envelope getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    public Set<Record> evaluate(DirectPosition directPosition, Collection<String> collection) throws PointOutsideCoverageException, CannotEvaluateException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public Object evaluate(DirectPosition directPosition) throws PointOutsideCoverageException, CannotEvaluateException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public boolean[] evaluate(DirectPosition directPosition, boolean[] booleans) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public byte[] evaluate(DirectPosition directPosition, byte[] bytes) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public int[] evaluate(DirectPosition directPosition, int[] ints) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public float[] evaluate(DirectPosition directPosition, float[] floats) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public double[] evaluate(DirectPosition directPosition, double[] dest) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        this.gridCoverage.evaluate(directPosition, dest);
        if (this.noData != null && this.noData.getAsSingleValue() == dest[0]) {
            throw new PointOutsideCoverageException("Value is NO_DATA.");
        }
        return dest;
    }

    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    static GridCoverage create(GridCoverage2D gridCoverage2D) {
        return new NoDataGridCoverage(gridCoverage2D);
    }
}

