/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.map;

import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.linearref.LinearLocation;

public class LinearIterator
implements Iterable<LinearLocation> {
    private final Geometry linearGeom;
    private final int numLines;
    private LineString currentLine;
    private int componentIndex = 0;
    private int vertexIndex = 0;
    private double segmentFraction;

    public LinearIterator(Geometry linear) {
        this(linear, 0, 0);
    }

    public LinearIterator(Geometry linear, LinearLocation start) {
        this(linear, start.getComponentIndex(), start.getSegmentIndex());
        this.segmentFraction = start.getSegmentFraction();
    }

    public LinearIterator(Geometry linearGeom, int componentIndex, int vertexIndex) {
        if (!(linearGeom instanceof Lineal)) {
            throw new IllegalArgumentException("Lineal geometry is required");
        }
        this.linearGeom = linearGeom;
        this.numLines = linearGeom.getNumGeometries();
        this.componentIndex = componentIndex;
        this.vertexIndex = vertexIndex;
        this.loadCurrentLine();
    }

    public static LinearLocation getEndLocation(Geometry linear) {
        int lastComponentIndex = linear.getNumGeometries() - 1;
        LineString lastLine = (LineString)linear.getGeometryN(lastComponentIndex);
        int lastSegmentIndex = lastLine.getNumPoints() - 1;
        return new LinearLocation(lastComponentIndex, lastSegmentIndex, 0.0);
    }

    public boolean hasNext() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.componentIndex != this.numLines - 1 || this.vertexIndex < this.currentLine.getNumPoints() - 1;
    }

    public boolean isValidIndex() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.componentIndex != this.numLines - 1 || this.vertexIndex < this.currentLine.getNumPoints();
    }

    public void next() {
        if (!this.hasNext()) {
            return;
        }
        this.segmentFraction = 0.0;
        ++this.vertexIndex;
        if (this.vertexIndex >= this.currentLine.getNumPoints()) {
            ++this.componentIndex;
            if (this.componentIndex < this.linearGeom.getNumGeometries() - 1) {
                this.loadCurrentLine();
                this.vertexIndex = 0;
            }
        }
    }

    public boolean isEndOfLine() {
        if (this.componentIndex >= this.numLines) {
            return false;
        }
        return this.vertexIndex >= this.currentLine.getNumPoints() - 1;
    }

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public int getVertexIndex() {
        return this.vertexIndex;
    }

    public LineString getLine() {
        return this.currentLine;
    }

    public Coordinate getSegmentStart() {
        return this.currentLine.getCoordinateN(this.vertexIndex);
    }

    public Coordinate getSegmentEnd() {
        if (this.vertexIndex < this.getLine().getNumPoints() - 1) {
            return this.currentLine.getCoordinateN(this.vertexIndex + 1);
        }
        return null;
    }

    public LinearLocation getLocation() {
        return new LinearLocation(this.componentIndex, this.vertexIndex, this.segmentFraction);
    }

    @Override
    public Iterator<LinearLocation> iterator() {
        return new LinearIteratorIterator();
    }

    private void loadCurrentLine() {
        if (this.componentIndex >= this.numLines) {
            this.currentLine = null;
            return;
        }
        this.currentLine = (LineString)this.linearGeom.getGeometryN(this.componentIndex);
    }

    class LinearIteratorIterator
    implements Iterator<LinearLocation> {
        LinearIteratorIterator() {
        }

        @Override
        public boolean hasNext() {
            return LinearIterator.this.hasNext();
        }

        @Override
        public LinearLocation next() {
            LinearLocation result = LinearIterator.this.getLocation();
            LinearIterator.this.next();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

