/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.islandpruning;

import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.module.islandpruning.Subgraph;
import org.opentripplanner.street.model.vertex.Vertex;

public record PrunedStopIsland(Subgraph island, int nothru, int restricted, int removed, String stopLabels) implements DataImportIssue
{
    private static final String FMT = "Unlinked stops from pruned walk subgraph %s of %d street vertices and %d stops %s. Edge changes: %d to nothru, %d to no walking, %d erased";
    private static final String HTMLFMT = "Unlinked stops from pruned walk <a href='http://www.openstreetmap.org/node/%s'>subgraph %s</a> of %d street vertices and %d stops %s. Edge changes: %d to nothru, %d to no walking, %d erased";

    @Override
    public String getMessage() {
        return String.format(FMT, this.island.getRepresentativeVertex().getLabel(), this.island.streetSize(), this.island.stopSize(), this.stopLabels, this.nothru, this.restricted, this.removed);
    }

    @Override
    public String getHTMLMessage() {
        String label = this.island.getRepresentativeVertex().getLabel();
        if (label.startsWith("osm:")) {
            String osmNodeId = label.split(":")[2];
            return String.format(HTMLFMT, osmNodeId, osmNodeId, this.island.streetSize(), this.island.stopSize(), this.stopLabels, this.nothru, this.restricted, this.removed);
        }
        return this.getMessage();
    }

    @Override
    public int getPriority() {
        return this.island.streetSize() + this.island.stopSize();
    }

    @Override
    public Vertex getReferencedVertex() {
        return this.island.getRepresentativeVertex();
    }

    @Override
    public Geometry getGeometry() {
        return this.island.getGeometry();
    }
}

