/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.interlining;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.InterliningTeleport;
import org.opentripplanner.gtfs.mapping.StaySeatedNotAllowed;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.DefaultTransferService;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterlineProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InterlineProcessor.class);
    private final DefaultTransferService transferService;
    private final int maxInterlineDistance;
    private final DataImportIssueStore issueStore;
    private final List<StaySeatedNotAllowed> staySeatedNotAllowed;

    public InterlineProcessor(DefaultTransferService transferService, List<StaySeatedNotAllowed> staySeatedNotAllowed, int maxInterlineDistance, DataImportIssueStore issueStore) {
        this.transferService = transferService;
        this.staySeatedNotAllowed = staySeatedNotAllowed;
        this.maxInterlineDistance = maxInterlineDistance > 0 ? maxInterlineDistance : 200;
        this.issueStore = issueStore;
    }

    public List<ConstrainedTransfer> run(Collection<TripPattern> tripPatterns) {
        Multimap<TripPatternPair, TripPair> interlinedTrips = this.getInterlinedTrips(tripPatterns);
        List<ConstrainedTransfer> transfers = interlinedTrips.entries().stream().filter(this::staySeatedAllowed).map(p -> {
            TransferConstraint.Builder constraint = TransferConstraint.create();
            constraint.staySeated();
            constraint.priority(TransferPriority.ALLOWED);
            Trip fromTrip = ((TripPair)p.getValue()).from();
            Trip toTrip = ((TripPair)p.getValue()).to();
            TripTransferPoint from = new TripTransferPoint(fromTrip, ((TripPatternPair)p.getKey()).from().numberOfStops() - 1);
            TripTransferPoint to = new TripTransferPoint(toTrip, 0);
            LOG.debug("Creating stay-seated transfer from trip {} (route {}) to trip {} (route {})", new Object[]{fromTrip.getId(), fromTrip.getRoute().getId(), toTrip.getId(), toTrip.getRoute().getId()});
            return new ConstrainedTransfer(null, from, to, constraint.build());
        }).toList();
        if (!transfers.isEmpty()) {
            LOG.info("Found {} pairs of trips for which stay-seated (interlined) transfers were created", (Object)transfers.size());
            this.transferService.addAll(transfers);
        }
        return transfers;
    }

    private boolean staySeatedAllowed(Map.Entry<TripPatternPair, TripPair> p) {
        Trip fromTrip = p.getValue().from();
        Trip toTrip = p.getValue().to();
        return this.staySeatedNotAllowed.stream().noneMatch(t -> t.fromTrip().getId().equals(fromTrip.getId()) && t.toTrip().getId().equals(toTrip.getId()));
    }

    private Multimap<TripPatternPair, TripPair> getInterlinedTrips(Collection<TripPattern> tripPatterns) {
        HashMap<TripTimes, TripPattern> patternForTripTimes = new HashMap<TripTimes, TripPattern>();
        ArrayListMultimap tripTimesForBlock = ArrayListMultimap.create();
        LOG.info("Finding interlining trips based on block IDs.");
        for (TripPattern pattern : tripPatterns) {
            Timetable timetable = pattern.getScheduledTimetable();
            for (TripTimes tripTimes : timetable.getTripTimes()) {
                Trip trip = tripTimes.getTrip();
                if (!StringUtils.hasValue(trip.getGtfsBlockId())) continue;
                tripTimesForBlock.put((Object)BlockIdAndServiceId.ofTrip(trip), (Object)tripTimes);
                patternForTripTimes.put(tripTimes, pattern);
            }
        }
        ArrayListMultimap interlines = ArrayListMultimap.create();
        block2: for (BlockIdAndServiceId block : tripTimesForBlock.keySet()) {
            List blockTripTimes = tripTimesForBlock.get((Object)block);
            Collections.sort(blockTripTimes);
            TripTimes prev = null;
            for (TripTimes curr : blockTripTimes) {
                if (prev != null) {
                    if (prev.getDepartureTime(prev.getNumStops() - 1) > curr.getArrivalTime(0)) {
                        LOG.error("Trip times within block {} are not increasing on service {} after trip {}.", new Object[]{block.blockId(), block.serviceId(), prev.getTrip().getId()});
                        continue block2;
                    }
                    TripPattern prevPattern = (TripPattern)patternForTripTimes.get(prev);
                    TripPattern currPattern = (TripPattern)patternForTripTimes.get(curr);
                    StopLocation fromStop = prevPattern.lastStop();
                    StopLocation toStop = currPattern.firstStop();
                    double teleportationDistance = SphericalDistanceLibrary.fastDistance(fromStop.getLat(), fromStop.getLon(), toStop.getLat(), toStop.getLon());
                    if (teleportationDistance > (double)this.maxInterlineDistance) {
                        this.issueStore.add(new InterliningTeleport(prev.getTrip(), block.blockId(), (int)teleportationDistance, fromStop, toStop));
                    } else {
                        interlines.put((Object)new TripPatternPair(prevPattern, currPattern), (Object)new TripPair(prev.getTrip(), curr.getTrip()));
                    }
                }
                prev = curr;
            }
        }
        return interlines;
    }

    private record TripPair(Trip from, Trip to) {
    }

    private record BlockIdAndServiceId(String blockId, FeedScopedId serviceId) {
        static BlockIdAndServiceId ofTrip(Trip trip) {
            return new BlockIdAndServiceId(trip.getGtfsBlockId(), trip.getServiceId());
        }
    }

    private record TripPatternPair(TripPattern from, TripPattern to) {
    }
}

