/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ParkAndRideEntranceRemoved;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.LinkingDirection;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingHelper;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.street.model.edge.StreetTransitEntranceLink;
import org.opentripplanner.street.model.edge.StreetTransitStopLink;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetLinkerModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(StreetLinkerModule.class);
    private final Graph graph;
    private final TransitModel transitModel;
    private final DataImportIssueStore issueStore;
    private final Boolean addExtraEdgesToAreas;

    public StreetLinkerModule(Graph graph, TransitModel transitModel, DataImportIssueStore issueStore, boolean addExtraEdgesToAreas) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.issueStore = issueStore;
        this.addExtraEdgesToAreas = addExtraEdgesToAreas;
    }

    public static void linkStreetsForTestOnly(Graph graph, TransitModel model) {
        new StreetLinkerModule(graph, model, DataImportIssueStore.NOOP, false).buildGraph();
    }

    @Override
    public void buildGraph() {
        this.transitModel.index();
        this.graph.index(this.transitModel.getStopModel());
        this.graph.getLinker().setAddExtraEdgesToAreas(this.addExtraEdgesToAreas);
        if (this.graph.hasStreets) {
            this.linkTransitStops(this.graph, this.transitModel);
            this.linkTransitEntrances(this.graph);
            this.linkVehicleParks(this.graph, this.issueStore);
        }
        this.graph.calculateConvexHull();
    }

    @Override
    public void checkInputs() {
    }

    public void linkTransitStops(Graph graph, TransitModel transitModel) {
        List<TransitStopVertex> vertices = graph.getVerticesOfType(TransitStopVertex.class);
        ProgressTracker progress = ProgressTracker.track("Linking transit stops to graph", 5000, vertices.size());
        LOG.info(progress.startMessage());
        Set<Object> stopLocationsUsedForFlexTrips = Set.of();
        if (OTPFeature.FlexRouting.isOn()) {
            stopLocationsUsedForFlexTrips = transitModel.getAllFlexTrips().stream().flatMap(t -> t.getStops().stream()).collect(Collectors.toSet());
            stopLocationsUsedForFlexTrips.addAll(stopLocationsUsedForFlexTrips.stream().filter(GroupStop.class::isInstance).map(GroupStop.class::cast).flatMap(g -> g.getLocations().stream().filter(RegularStop.class::isInstance)).toList());
        }
        for (TransitStopVertex tStop : vertices) {
            if (tStop.hasPathways() || tStop.getDegreeOut() + tStop.getDegreeIn() > 0) continue;
            TraverseModeSet modes = new TraverseModeSet(TraverseMode.WALK);
            if (OTPFeature.FlexRouting.isOn() && stopLocationsUsedForFlexTrips.contains(tStop.getStop())) {
                modes = new TraverseModeSet(TraverseMode.WALK, TraverseMode.CAR);
            }
            graph.getLinker().linkVertexPermanently(tStop, modes, LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetTransitStopLink((TransitStopVertex)vertex, (StreetVertex)streetVertex), new StreetTransitStopLink((StreetVertex)streetVertex, (TransitStopVertex)vertex)));
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private static void linkVehicleParkingWithLinker(Graph graph, VehicleParkingEntranceVertex vehicleParkingVertex) {
        if (vehicleParkingVertex.isWalkAccessible()) {
            graph.getLinker().linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleParkingLink((StreetVertex)streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
        if (vehicleParkingVertex.isCarAccessible()) {
            graph.getLinker().linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.CAR), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleParkingLink((StreetVertex)streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
    }

    private void linkTransitEntrances(Graph graph) {
        LOG.info("Linking transit entrances to graph...");
        for (TransitEntranceVertex tEntrance : graph.getVerticesOfType(TransitEntranceVertex.class)) {
            graph.getLinker().linkVertexPermanently(tEntrance, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetTransitEntranceLink((TransitEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetTransitEntranceLink((StreetVertex)streetVertex, (TransitEntranceVertex)vertex)));
        }
    }

    private void linkVehicleParks(Graph graph, DataImportIssueStore issueStore) {
        if (graph.hasLinkedBikeParks) {
            LOG.info("Already linked vehicle parks to graph...");
            return;
        }
        LOG.info("Linking vehicle parks to graph...");
        ArrayList<VehicleParking> vehicleParkingToRemove = new ArrayList<VehicleParking>();
        for (VehicleParkingEntranceVertex vehicleParkingEntranceVertex : graph.getVerticesOfType(VehicleParkingEntranceVertex.class)) {
            if (this.vehicleParkingEntranceHasLinks(vehicleParkingEntranceVertex)) continue;
            if (vehicleParkingEntranceVertex.getParkingEntrance().getVertex() == null) {
                StreetLinkerModule.linkVehicleParkingWithLinker(graph, vehicleParkingEntranceVertex);
                continue;
            }
            if (graph.containsVertex(vehicleParkingEntranceVertex.getParkingEntrance().getVertex())) {
                VehicleParkingHelper.linkToGraph(vehicleParkingEntranceVertex);
                continue;
            }
            issueStore.add(new ParkAndRideEntranceRemoved(vehicleParkingEntranceVertex.getParkingEntrance()));
            VehicleParking vehicleParking = this.removeVehicleParkingEntranceVertexFromGraph(vehicleParkingEntranceVertex, graph);
            if (vehicleParking == null) continue;
            vehicleParkingToRemove.add(vehicleParking);
        }
        if (!vehicleParkingToRemove.isEmpty()) {
            VehicleParkingService vehicleParkingService = graph.getVehicleParkingService();
            vehicleParkingService.updateVehicleParking(List.of(), vehicleParkingToRemove);
        }
        graph.hasLinkedBikeParks = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean vehicleParkingEntranceHasLinks(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        if (!vehicleParkingEntranceVertex.getIncoming().stream().allMatch(VehicleParkingEdge.class::isInstance)) return true;
        if (vehicleParkingEntranceVertex.getOutgoing().stream().allMatch(VehicleParkingEdge.class::isInstance)) return false;
        return true;
    }

    private VehicleParking removeVehicleParkingEntranceVertexFromGraph(VehicleParkingEntranceVertex vehicleParkingEntranceVertex, Graph graph) {
        VehicleParkingEdge vehicleParkingEdge = vehicleParkingEntranceVertex.getOutgoing().stream().filter(VehicleParkingEdge.class::isInstance).map(VehicleParkingEdge.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("VehicleParkingEdge missing from vertex: " + vehicleParkingEntranceVertex));
        VehicleParkingEntrance entrance = vehicleParkingEntranceVertex.getParkingEntrance();
        VehicleParking vehicleParking = vehicleParkingEdge.getVehicleParking();
        boolean removeVehicleParking = vehicleParking.getEntrances().size() == 1 && vehicleParking.getEntrances().get(0).equals(entrance);
        vehicleParkingEntranceVertex.getIncoming().forEach(graph::removeEdge);
        vehicleParkingEntranceVertex.getOutgoing().forEach(graph::removeEdge);
        graph.remove(vehicleParkingEntranceVertex);
        if (removeVehicleParking) {
            return vehicleParking;
        }
        vehicleParking.getEntrances().remove(entrance);
        return null;
    }
}

