/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.tostring;

import java.time.Duration;
import java.util.function.Function;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;

public class ValueObjectToStringBuilder {
    private static final String FIELD_SEPARATOR = " ";
    private final StringBuilder sb = new StringBuilder();
    private final OtpNumberFormat numFormat = new OtpNumberFormat();
    boolean skipSep = true;
    boolean skipNull = false;

    private ValueObjectToStringBuilder() {
    }

    public static ValueObjectToStringBuilder of() {
        return new ValueObjectToStringBuilder();
    }

    public ValueObjectToStringBuilder skipNull() {
        this.skipNull = true;
        return this;
    }

    public ValueObjectToStringBuilder includeNull() {
        this.skipNull = false;
        return this;
    }

    public ValueObjectToStringBuilder addNum(Number num) {
        return this.addIt(num, this.numFormat::formatNumber);
    }

    public ValueObjectToStringBuilder addNum(Number num, String unit) {
        return this.addIt(num, it -> this.numFormat.formatNumber((Number)it, unit));
    }

    public ValueObjectToStringBuilder addBool(Boolean value, String ifTrue, String ifFalse) {
        return this.addIt(value, it -> it != false ? ifTrue : ifFalse);
    }

    public ValueObjectToStringBuilder addStr(String value) {
        return this.addIt(value, it -> "'" + it + "'");
    }

    public ValueObjectToStringBuilder addText(String label) {
        this.sb.append(label);
        this.skipSep = true;
        return this;
    }

    public ValueObjectToStringBuilder addEnum(Enum<?> value) {
        return this.addIt(value, Enum::name);
    }

    public ValueObjectToStringBuilder addObj(Object obj) {
        return this.addIt(obj, Object::toString);
    }

    public ValueObjectToStringBuilder addCoordinate(Number lat, Number lon) {
        if (this.skipNull && lat == null && lon == null) {
            return this;
        }
        return this.addIt("(" + this.numFormat.formatCoordinate(lat) + ", " + this.numFormat.formatCoordinate(lon) + ")");
    }

    public ValueObjectToStringBuilder addServiceTime(int secondsPastMidnight) {
        return this.addServiceTime(secondsPastMidnight, -87654321);
    }

    public ValueObjectToStringBuilder addServiceTime(int secondsPastMidnight, int notSet) {
        return this.addIt(TimeUtils.timeToStrCompact(secondsPastMidnight, notSet));
    }

    public ValueObjectToStringBuilder addDuration(Duration duration) {
        return this.addIt(duration, DurationUtils::durationToStr);
    }

    public ValueObjectToStringBuilder addDurationSec(Integer durationSeconds) {
        return this.addIt(durationSeconds, DurationUtils::durationToStr);
    }

    public ValueObjectToStringBuilder addCost(Integer costSeconds) {
        return this.addIt(costSeconds, OtpNumberFormat::formatCost);
    }

    public ValueObjectToStringBuilder addCostCenti(Integer costCentiSeconds) {
        return this.addIt(costCentiSeconds, OtpNumberFormat::formatCostCenti);
    }

    public ValueObjectToStringBuilder addCostCenti(Integer costCentiSeconds, String unit) {
        return this.addIt(costCentiSeconds, it -> OtpNumberFormat.formatCost(it, unit));
    }

    public String toString() {
        return this.sb.toString();
    }

    private ValueObjectToStringBuilder addIt(String value) {
        return this.addIt(value, it -> it);
    }

    private <T> ValueObjectToStringBuilder addIt(T value, Function<T, String> mapToString) {
        if (this.skipNull && value == null) {
            return this;
        }
        if (this.skipSep) {
            this.skipSep = false;
        } else {
            this.sb.append(FIELD_SEPARATOR);
        }
        this.sb.append(value == null ? "null" : mapToString.apply(value));
        return this;
    }
}

