/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.time;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceDateUtils {
    private static final String MAX_TEXT = "MAX";
    private static final String MIN_TEXT = "MIN";
    private static final Pattern PATTERN = Pattern.compile("^(\\d{4})-?(\\d{2})-?(\\d{2})$");
    private static final DateTimeFormatter COMPACT_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd");

    public static ZonedDateTime asStartOfService(Instant time, ZoneId zoneId) {
        LocalDate date = LocalDate.ofInstant(time, zoneId);
        return ServiceDateUtils.asStartOfService(date, zoneId);
    }

    public static ZonedDateTime asStartOfService(LocalDate localDate, ZoneId zoneId) {
        return ZonedDateTime.of(localDate, LocalTime.NOON, zoneId).minusHours(12L);
    }

    public static LocalDate asServiceDay(ZonedDateTime startOfService) {
        return startOfService.plusHours(12L).toLocalDate();
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate, ZoneId zoneId, int secondsOffset) {
        return ServiceDateUtils.asStartOfService(localDate, zoneId).plusSeconds(secondsOffset);
    }

    public static int secondsSinceStartOfTime(ZonedDateTime timeZero, LocalDate localDate) {
        ZonedDateTime startOfDay = ServiceDateUtils.asStartOfService(localDate, timeZero.getZone());
        return (int)Duration.between(timeZero, startOfDay).getSeconds();
    }

    public static int secondsSinceStartOfTime(ZonedDateTime startOfTime, Instant instant) {
        return (int)Duration.between(startOfTime.toInstant(), instant).getSeconds();
    }

    public static LocalDateTime asDateTime(LocalDate localDate, int secondsSinceStartOfDay) {
        return localDate.atStartOfDay().plusSeconds(secondsSinceStartOfDay);
    }

    public static int secondsSinceStartOfService(ZonedDateTime operatingDayDate, ZonedDateTime dateTime, ZoneId zoneId) {
        ZonedDateTime startOfService = ServiceDateUtils.asStartOfService(operatingDayDate.withZoneSameInstant(zoneId).toLocalDate(), zoneId);
        return (int)Duration.between(startOfService, dateTime).toSeconds();
    }

    public static int secondsSinceStartOfService(ZonedDateTime startOfService, ZonedDateTime dateTime) {
        return (int)Duration.between(startOfService, dateTime).toSeconds();
    }

    public static LocalDate parseString(String value) throws ParseException {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new ParseException("error parsing date: " + value, 0);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        return LocalDate.of(year, month, day);
    }

    public static Optional<LocalDate> parseStringToOptional(String value) {
        try {
            return Optional.of(ServiceDateUtils.parseString(value));
        }
        catch (ParseException e) {
            return Optional.empty();
        }
    }

    public static boolean isMinMax(LocalDate date) {
        return LocalDate.MIN.equals(date) || LocalDate.MAX.equals(date);
    }

    public static LocalDate max(LocalDate a, LocalDate b) {
        return a.isAfter(b) ? a : b;
    }

    public static LocalDate min(LocalDate a, LocalDate b) {
        return a.isBefore(b) ? a : b;
    }

    public static String asCompactString(LocalDate date) {
        return date.format(COMPACT_FORMATTER);
    }

    public static String toString(LocalDate date) {
        if (LocalDate.MAX.equals(date)) {
            return MAX_TEXT;
        }
        if (LocalDate.MIN.equals(date)) {
            return MIN_TEXT;
        }
        return date.toString();
    }
}

