/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import org.opentripplanner.framework.text.Table;

public class TableBuilder {
    private List<Table.Align> aligns = null;
    private List<String> headers = null;
    private List<Integer> minWidths = null;
    private final List<List<String>> rows = new ArrayList<List<String>>();

    List<String> headers() {
        return this.headers;
    }

    public TableBuilder withHeaders(String ... headers) {
        return this.withHeaders(Arrays.asList(headers));
    }

    public TableBuilder withHeaders(Collection<String> headers) {
        this.headers = new ArrayList<String>(headers);
        return this;
    }

    List<Table.Align> aligns() {
        return this.aligns != null ? this.aligns : this.headers.stream().map(it -> Table.Align.Left).toList();
    }

    public TableBuilder withAlights(Table.Align ... aligns) {
        return this.withAlights(Arrays.asList(aligns));
    }

    public TableBuilder withAlights(Collection<Table.Align> aligns) {
        this.aligns = List.copyOf(aligns);
        return this;
    }

    List<Integer> calculateWidths() {
        ArrayList<Integer> widths = new ArrayList<Integer>(this.numberOfColumns());
        for (int i = 0; i < this.numberOfColumns(); ++i) {
            widths.add(this.findMaxWidth(i));
        }
        return widths;
    }

    public TableBuilder withMinWidths(int ... widths) {
        return this.withMinWidths(IntStream.of(widths).boxed().toList());
    }

    public TableBuilder withMinWidths(Collection<Integer> widths) {
        this.minWidths = List.copyOf(widths);
        return this;
    }

    public List<List<String>> rows() {
        return this.rows;
    }

    public TableBuilder addRow(Object ... cells) {
        return this.addRow(Arrays.asList(cells));
    }

    public TableBuilder addRow(Collection<?> row) {
        this.rows.add(Table.normalizeRow(row, this.numberOfColumns()));
        return this;
    }

    public Table build() {
        return new Table(this);
    }

    public String toString() {
        return this.build().toString();
    }

    private int findMaxWidth(int column) {
        int width0 = this.headers.get(column).length();
        if (this.minWidths != null) {
            if (this.minWidths.size() != this.numberOfColumns()) {
                throw new IllegalStateException("Number minWidths does not match number of columns. MinWidths=" + this.minWidths.size() + ", columns=" + this.numberOfColumns());
            }
            width0 = Math.max(width0, this.minWidths.get(column));
        }
        return this.rows.stream().map(it -> (String)it.get(column)).mapToInt(it -> it == null ? 0 : it.length()).reduce(width0, Math::max);
    }

    private int numberOfColumns() {
        return this.headers.size();
    }
}

