/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.lang;

import javax.annotation.Nonnull;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean hasValue(String text) {
        return text != null && !text.isBlank();
    }

    public static String assertHasValue(String value) {
        return StringUtils.assertHasValue(value, "", new Object[0]);
    }

    public static String assertHasValue(String value, String errorMessage, Object ... placeholders) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException(errorMessage.formatted(placeholders) + " [Value cannot be null, empty or just whitespace: " + (String)(value == null ? "null]" : "'" + value + "']"));
        }
        return value;
    }

    public static StringBuilder append(StringBuilder buffer, char ch, int count) {
        while (count > 0) {
            buffer.append(ch);
            --count;
        }
        return buffer;
    }

    public static String padLeft(String value, char ch, int width) {
        if (value == null) {
            return String.valueOf(ch).repeat(width);
        }
        if (value.length() >= width) {
            return value;
        }
        return StringUtils.append(new StringBuilder(), ch, width - value.length()).append(value).toString();
    }

    public static String padBoth(String value, char ch, int width) {
        if (value == null) {
            return String.valueOf(ch).repeat(width);
        }
        if (value.length() >= width) {
            return value;
        }
        StringBuilder buf = new StringBuilder();
        StringUtils.append(buf, ch, (width + 1 - value.length()) / 2);
        buf.append(value);
        StringUtils.append(buf, ch, width - buf.length());
        return buf.toString();
    }

    public static String padRight(String value, char ch, int width) {
        if (value == null) {
            return String.valueOf(ch).repeat(width);
        }
        if (value.length() >= width) {
            return value;
        }
        return StringUtils.append(new StringBuilder(value), ch, width - value.length()).toString();
    }

    public static String quoteReplace(@Nonnull String text) {
        return text.replace('\'', '\"');
    }
}

