/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.lang;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class OtpNumberFormat {
    private static final String NULL_VALUE = "null";
    private static final DecimalFormatSymbols DECIMAL_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.ROOT);
    private DecimalFormat integerFormat;
    private DecimalFormat decimalFormat;
    private DecimalFormat coordinateFormat;

    public static String formatCost(int cost) {
        return "$" + cost;
    }

    public static String formatCostCenti(int cost) {
        if (Math.abs(cost) >= 1000000 || cost % 100 == 0) {
            return "$" + cost / 100;
        }
        return String.format(Locale.ROOT, "$%.2f", (double)cost / 100.0);
    }

    public static String formatCost(int cost, String unit) {
        return OtpNumberFormat.formatCostCenti(cost) + unit;
    }

    public String formatCoordinate(Number value) {
        if (this.coordinateFormat == null) {
            this.coordinateFormat = new DecimalFormat("#0.0####", DECIMAL_SYMBOLS);
        }
        return value == null ? NULL_VALUE : this.coordinateFormat.format(value);
    }

    public String formatNumber(Number value, String unit) {
        return this.formatNumber(value) + unit;
    }

    public String formatNumber(Number value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger) {
            if (this.integerFormat == null) {
                this.integerFormat = new DecimalFormat("#,##0", DECIMAL_SYMBOLS);
            }
            return this.integerFormat.format(value);
        }
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("#,##0.0##", DECIMAL_SYMBOLS);
        }
        return this.decimalFormat.format(value);
    }

    public static String formatZeroDecimal(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0", DECIMAL_SYMBOLS);
        return decimalFormat.format(value);
    }

    public static String formatTwoDecimals(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.0#", DECIMAL_SYMBOLS);
        return decimalFormat.format(value);
    }
}

