/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class IntUtils {
    private IntUtils() {
    }

    public static String intToString(int value, int notSetValue) {
        return value == notSetValue ? "" : Integer.toString(value);
    }

    public static int[] intArray(int size, int initialValue) {
        int[] array = new int[size];
        Arrays.fill(array, initialValue);
        return array;
    }

    public static int[] shiftArray(int offset, int[] array) {
        int[] a = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i] + offset;
        }
        return a;
    }

    public static int[] concat(Collection<Integer> a, Collection<Integer> b) {
        ArrayList<Integer> all = new ArrayList<Integer>(a);
        all.addAll(b);
        return all.stream().mapToInt(it -> it).toArray();
    }

    public static double standardDeviation(List<Integer> v) {
        double average = v.stream().mapToInt(it -> it).average().orElse(0.0);
        double sum = 0.0;
        Iterator<Integer> iterator = v.iterator();
        while (iterator.hasNext()) {
            double num = iterator.next().intValue();
            sum += Math.pow(num - average, 2.0);
        }
        return Math.sqrt(sum / (double)v.size());
    }
}

