/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(5L);
    public static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    public static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    public static final String HEADER_HOST = "Host";
    public static final String APPLICATION_X_PROTOBUF = "application/x-protobuf";

    public static InputStream getData(URI uri) throws IOException {
        return HttpUtils.getData(uri, null);
    }

    public static InputStream getData(String uri) throws IOException {
        return HttpUtils.getData(URI.create(uri));
    }

    public static InputStream getData(String uri, Map<String, String> headers) throws IOException {
        return HttpUtils.getData(URI.create(uri), headers);
    }

    public static InputStream getData(URI uri, Duration timeout, Map<String, String> requestHeaderValues) throws IOException {
        HttpResponse response = HttpUtils.getResponse((HttpRequestBase)new HttpGet(uri), timeout, requestHeaderValues);
        if (response.getStatusLine().getStatusCode() != 200) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getContent();
    }

    public static InputStream getData(URI uri, Map<String, String> requestHeaderValues) throws IOException {
        return HttpUtils.getData(uri, DEFAULT_TIMEOUT, requestHeaderValues);
    }

    public static List<Header> getHeaders(URI uri, Duration timeout, Map<String, String> requestHeaderValues) {
        HttpResponse response;
        try {
            response = HttpUtils.getResponse((HttpRequestBase)new HttpHead(uri), timeout, requestHeaderValues);
        }
        catch (IOException e) {
            throw new RuntimeException("Network error while querying headers for resource " + HttpUtils.sanitizeUri(uri), e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            LOG.warn("Headers of Resource {} unavailable. HTTP error code {}", (Object)HttpUtils.sanitizeUri(uri), (Object)response.getStatusLine().getStatusCode());
            return Collections.emptyList();
        }
        return Arrays.stream(response.getAllHeaders()).toList();
    }

    private static String sanitizeUri(URI uri) {
        return uri.toString().replace("?" + uri.getQuery(), "");
    }

    public static InputStream openInputStream(String url, Map<String, String> headers) throws IOException {
        return HttpUtils.openInputStream(URI.create(url), headers);
    }

    public static InputStream openInputStream(URI uri, Map<String, String> headers) throws IOException {
        URL downloadUrl = uri.toURL();
        String proto = downloadUrl.getProtocol();
        if (proto.equals("http") || proto.equals("https")) {
            return HttpUtils.getData(uri, headers);
        }
        return downloadUrl.openStream();
    }

    public static String getBaseAddress(UriInfo uri, HttpHeaders headers) {
        String protocol = headers.getRequestHeader(HEADER_X_FORWARDED_PROTO) != null ? (String)headers.getRequestHeader(HEADER_X_FORWARDED_PROTO).get(0) : uri.getRequestUri().getScheme();
        Object host = headers.getRequestHeader(HEADER_X_FORWARDED_HOST) != null ? (String)headers.getRequestHeader(HEADER_X_FORWARDED_HOST).get(0) : (headers.getRequestHeader(HEADER_HOST) != null ? (String)headers.getRequestHeader(HEADER_HOST).get(0) : uri.getBaseUri().getHost() + ":" + uri.getBaseUri().getPort());
        return protocol + "://" + (String)host;
    }

    private static HttpResponse getResponse(HttpRequestBase httpRequest, Duration timeout, Map<String, String> requestHeaderValues) throws IOException {
        int to = (int)timeout.toMillis();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(to).setConnectTimeout(to).setConnectionRequestTimeout(to).build();
        httpRequest.setConfig(requestConfig);
        if (requestHeaderValues != null) {
            for (Map.Entry<String, String> entry : requestHeaderValues.entrySet()) {
                httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientBuilder.create().build().execute((HttpUriRequest)httpRequest);
    }
}

