/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.graphql;

import graphql.schema.DataFetchingEnvironment;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opentripplanner.framework.i18n.I18NString;

public class GraphQLUtils {
    public static String getTranslation(I18NString input, DataFetchingEnvironment environment) {
        if (input == null) {
            return null;
        }
        return input.toString(GraphQLUtils.getLocale(environment));
    }

    public static Locale getLocale(DataFetchingEnvironment environment) {
        return GraphQLUtils.getLocale(environment, (String)environment.getArgument("language"));
    }

    public static Locale getLocale(DataFetchingEnvironment environment, String localeString) {
        if (localeString != null) {
            return Locale.forLanguageTag(localeString);
        }
        Locale userLocale = environment.getLocale();
        Optional<Locale> defaultLocale = GraphQLUtils.getDefaultLocale(environment);
        if (userLocale == null) {
            return defaultLocale.orElse(Locale.forLanguageTag("*"));
        }
        if (defaultLocale.isPresent() && GraphQLUtils.acceptAnyLocale(userLocale)) {
            return defaultLocale.get();
        }
        return userLocale;
    }

    private static Optional<Locale> getDefaultLocale(DataFetchingEnvironment environment) {
        Map localContext = (Map)environment.getLocalContext();
        if (localContext == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Locale)localContext.get("locale"));
    }

    private static boolean acceptAnyLocale(@Nonnull Locale locale) {
        return locale.getLanguage().equals("*");
    }
}

