/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.geometry;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.tostring.ValueObjectToStringBuilder;

public final class WgsCoordinate
implements Serializable {
    public static final WgsCoordinate GREENWICH = new WgsCoordinate(51.48, 0.0);
    private static final double LAT_MIN = -90.0;
    private static final double LAT_MAX = 90.0;
    private static final double LON_MIN = -180.0;
    private static final double LON_MAX = 180.0;
    private final double latitude;
    private final double longitude;

    public WgsCoordinate(double latitude, double longitude) {
        DoubleUtils.assertInRange(latitude, -90.0, 90.0, "latitude");
        DoubleUtils.assertInRange(longitude, -180.0, 180.0, "longitude");
        this.latitude = DoubleUtils.roundTo7Decimals(latitude);
        this.longitude = DoubleUtils.roundTo7Decimals(longitude);
    }

    public WgsCoordinate(Point point) {
        Objects.requireNonNull(point);
        this.latitude = DoubleUtils.roundTo7Decimals(point.getY());
        this.longitude = DoubleUtils.roundTo7Decimals(point.getX());
    }

    public WgsCoordinate(Coordinate coordinate) {
        Objects.requireNonNull(coordinate);
        this.latitude = DoubleUtils.roundTo7Decimals(coordinate.getY());
        this.longitude = DoubleUtils.roundTo7Decimals(coordinate.getX());
    }

    public static WgsCoordinate creatOptionalCoordinate(Double latitude, Double longitude) {
        if (latitude == null && longitude == null) {
            return null;
        }
        if (latitude != null && longitude != null) {
            return new WgsCoordinate(latitude, longitude);
        }
        throw new IllegalArgumentException("Both 'latitude' and 'longitude' must have a value or both must be 'null'.");
    }

    public static WgsCoordinate mean(Collection<WgsCoordinate> coordinates) {
        if (coordinates.isEmpty()) {
            throw new IllegalArgumentException("Unable to calculate mean for an empty set of coordinates");
        }
        if (coordinates.size() == 1) {
            return coordinates.iterator().next();
        }
        double n = coordinates.size();
        double latitude = 0.0;
        double longitude = 0.0;
        for (WgsCoordinate c : coordinates) {
            latitude += c.latitude();
            longitude += c.longitude();
        }
        return new WgsCoordinate(latitude / n, longitude / n);
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }

    public Coordinate asJtsCoordinate() {
        return new Coordinate(this.longitude, this.latitude);
    }

    public boolean sameLocation(WgsCoordinate other) {
        return this.equals(other);
    }

    public WgsCoordinate add(double deltaLat, double deltaLon) {
        return new WgsCoordinate(this.latitude + deltaLat, this.longitude + deltaLon);
    }

    public WgsCoordinate roundToApproximate10m() {
        double lat = DoubleUtils.roundTo4Decimals(this.latitude);
        double lng = DoubleUtils.roundTo4Decimals(this.longitude);
        return new WgsCoordinate(lat, lng);
    }

    public String toString() {
        return ValueObjectToStringBuilder.of().addCoordinate(this.latitude(), this.longitude()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WgsCoordinate other = (WgsCoordinate)o;
        return this.latitude == other.latitude && this.longitude == other.longitude;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }
}

