/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.geojson.GeoJsonObject;
import org.geojson.LngLatAlt;
import org.geojson.MultiPolygon;
import org.geojson.Point;
import org.geotools.referencing.CRS;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.linearref.LengthLocationMap;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opentripplanner.framework.geometry.CoordinateArrayListSequence;
import org.opentripplanner.framework.geometry.SplitLineString;
import org.opentripplanner.framework.geometry.UnsupportedGeometryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryUtils.class);
    private static final CoordinateSequenceFactory csf = new PackedCoordinateSequenceFactory();
    private static final GeometryFactory gf = new GeometryFactory(csf);
    public static final CoordinateReferenceSystem WGS84_XY;

    public static <T> Geometry makeConvexHull(Collection<T> collection, Function<T, Coordinate> mapToCoordinate) {
        GeometryFactory gf = GeometryUtils.getGeometryFactory();
        Geometry[] points = new Geometry[collection.size()];
        int i = 0;
        for (T v : collection) {
            points[i++] = gf.createPoint(mapToCoordinate.apply(v));
        }
        GeometryCollection col = new GeometryCollection(points, gf);
        return new ConvexHull((Geometry)col).getConvexHull();
    }

    public static LineString makeLineString(double ... coords) {
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        Coordinate[] coordinates = new Coordinate[coords.length / 2];
        for (int i = 0; i < coords.length; i += 2) {
            coordinates[i / 2] = new Coordinate(coords[i], coords[i + 1]);
        }
        return factory.createLineString(coordinates);
    }

    public static LineString makeLineString(List<Coordinate> coordinates) {
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        return factory.createLineString(coordinates.toArray(new Coordinate[0]));
    }

    public static LineString makeLineString(Coordinate[] coordinates) {
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        return factory.createLineString(coordinates);
    }

    public static <T> LineString concatenateLineStrings(List<T> inputObjects, Function<T, LineString> mapper) {
        return GeometryUtils.concatenateLineStrings(inputObjects.stream().map(mapper).toList());
    }

    public static LineString concatenateLineStrings(List<LineString> lineStrings) {
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        Predicate<Coordinate[]> nonZeroLength = coordinates -> ((Coordinate[])coordinates).length != 0;
        return factory.createLineString((CoordinateSequence)lineStrings.stream().filter(Objects::nonNull).map(LineString::getCoordinates).filter(nonZeroLength).collect(CoordinateArrayListSequence::new, (acc, segment) -> {
            if (acc.size() == 0 || !acc.getCoordinate(acc.size() - 1).equals((Object)segment[0])) {
                acc.extend((Coordinate[])segment);
            } else {
                acc.extend((Coordinate[])segment, 1);
            }
        }, (head, tail) -> head.extend(tail.toCoordinateArray())));
    }

    public static LineString addStartEndCoordinatesToLineString(Coordinate startCoord, LineString lineString, Coordinate endCoord) {
        Coordinate[] coordinates = new Coordinate[lineString.getCoordinates().length + 2];
        coordinates[0] = startCoord;
        for (int j = 0; j < lineString.getCoordinates().length; ++j) {
            coordinates[j + 1] = lineString.getCoordinates()[j];
        }
        coordinates[lineString.getCoordinates().length + 1] = endCoord;
        return GeometryUtils.makeLineString(coordinates);
    }

    public static LineString removeStartEndCoordinatesFromLineString(LineString lineString) {
        Coordinate[] coordinates = new Coordinate[lineString.getCoordinates().length - 2];
        for (int j = 1; j < lineString.getCoordinates().length - 1; ++j) {
            coordinates[j - 1] = lineString.getCoordinates()[j];
        }
        return GeometryUtils.makeLineString(coordinates);
    }

    public static GeometryFactory getGeometryFactory() {
        return gf;
    }

    public static SplitLineString splitGeometryAtPoint(Geometry geometry, Coordinate nearestPoint) {
        LocationIndexedLine line = new LocationIndexedLine(geometry);
        LinearLocation l = line.indexOf(nearestPoint);
        LineString beginning = (LineString)line.extractLine(line.getStartIndex(), l);
        LineString ending = (LineString)line.extractLine(l, line.getEndIndex());
        return new SplitLineString(beginning, ending);
    }

    public static SplitLineString splitGeometryAtFraction(Geometry geometry, double fraction) {
        LineString empty = new LineString(null, gf);
        Coordinate[] coordinates = geometry.getCoordinates();
        CoordinateSequence sequence = gf.getCoordinateSequenceFactory().create(coordinates);
        LineString total = new LineString(sequence, gf);
        if (coordinates.length < 2) {
            return new SplitLineString(empty, empty);
        }
        if (fraction <= 0.0) {
            return new SplitLineString(empty, total);
        }
        if (fraction >= 1.0) {
            return new SplitLineString(total, empty);
        }
        double totalDistance = total.getLength();
        double requestedDistance = totalDistance * fraction;
        LocationIndexedLine line = new LocationIndexedLine(geometry);
        LinearLocation l = LengthLocationMap.getLocation((Geometry)geometry, (double)requestedDistance);
        LineString beginning = (LineString)line.extractLine(line.getStartIndex(), l);
        LineString ending = (LineString)line.extractLine(l, line.getEndIndex());
        return new SplitLineString(beginning, ending);
    }

    public static LineString getInteriorSegment(Geometry geomerty, Coordinate first, Coordinate second) {
        SplitLineString splitGeom = GeometryUtils.splitGeometryAtPoint(geomerty, first);
        splitGeom = GeometryUtils.splitGeometryAtPoint((Geometry)splitGeom.ending(), second);
        return splitGeom.beginning();
    }

    public static Geometry convertGeoJsonToJtsGeometry(GeoJsonObject geoJsonGeom) throws UnsupportedGeometryException {
        if (geoJsonGeom instanceof Point) {
            Point geoJsonPoint = (Point)geoJsonGeom;
            return gf.createPoint(new Coordinate(geoJsonPoint.getCoordinates().getLongitude(), geoJsonPoint.getCoordinates().getLatitude(), geoJsonPoint.getCoordinates().getAltitude()));
        }
        if (geoJsonGeom instanceof org.geojson.Polygon) {
            org.geojson.Polygon geoJsonPolygon = (org.geojson.Polygon)geoJsonGeom;
            LinearRing shell = gf.createLinearRing(GeometryUtils.convertPath(geoJsonPolygon.getExteriorRing()));
            LinearRing[] holes = new LinearRing[geoJsonPolygon.getInteriorRings().size()];
            int i = 0;
            for (List hole : geoJsonPolygon.getInteriorRings()) {
                holes[i++] = gf.createLinearRing(GeometryUtils.convertPath(hole));
            }
            return gf.createPolygon(shell, holes);
        }
        if (geoJsonGeom instanceof MultiPolygon) {
            MultiPolygon geoJsonMultiPolygon = (MultiPolygon)geoJsonGeom;
            Polygon[] jtsPolygons = new Polygon[geoJsonMultiPolygon.getCoordinates().size()];
            int i = 0;
            for (List geoJsonRings : geoJsonMultiPolygon.getCoordinates()) {
                org.geojson.Polygon geoJsonPoly = new org.geojson.Polygon();
                for (List geoJsonRing : geoJsonRings) {
                    geoJsonPoly.add((Object)geoJsonRing);
                }
                jtsPolygons[i++] = (Polygon)GeometryUtils.convertGeoJsonToJtsGeometry((GeoJsonObject)geoJsonPoly);
            }
            return gf.createMultiPolygon(jtsPolygons);
        }
        if (geoJsonGeom instanceof org.geojson.LineString) {
            org.geojson.LineString geoJsonLineString = (org.geojson.LineString)geoJsonGeom;
            return gf.createLineString(GeometryUtils.convertPath(geoJsonLineString.getCoordinates()));
        }
        if (geoJsonGeom instanceof org.geojson.MultiLineString) {
            org.geojson.MultiLineString geoJsonMultiLineString = (org.geojson.MultiLineString)geoJsonGeom;
            LineString[] jtsLineStrings = new LineString[geoJsonMultiLineString.getCoordinates().size()];
            int i = 0;
            for (List geoJsonPath : geoJsonMultiLineString.getCoordinates()) {
                org.geojson.LineString geoJsonLineString = new org.geojson.LineString(geoJsonPath.toArray(new LngLatAlt[geoJsonPath.size()]));
                jtsLineStrings[i++] = (LineString)GeometryUtils.convertGeoJsonToJtsGeometry((GeoJsonObject)geoJsonLineString);
            }
            return gf.createMultiLineString(jtsLineStrings);
        }
        throw new UnsupportedGeometryException(geoJsonGeom.getClass().toString());
    }

    public static List<LineString> getLineStrings(MultiLineString mls) {
        ArrayList<LineString> ret = new ArrayList<LineString>();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            ret.add((LineString)mls.getGeometryN(i));
        }
        return List.copyOf(ret);
    }

    private static Coordinate[] convertPath(List<LngLatAlt> path) {
        Coordinate[] coords = new Coordinate[path.size()];
        int i = 0;
        for (LngLatAlt p : path) {
            coords[i++] = new Coordinate(p.getLongitude(), p.getLatitude(), p.getAltitude());
        }
        return coords;
    }

    public static Stream<Envelope> toEnvelopes(LineString ls) {
        Coordinate[] coordinates = ls.getCoordinates();
        Envelope[] envelopes = new Envelope[coordinates.length - 1];
        for (int i = 0; i < envelopes.length; ++i) {
            Coordinate from = coordinates[i];
            Coordinate to = coordinates[i + 1];
            envelopes[i] = new Envelope(from, to);
        }
        return Arrays.stream(envelopes);
    }

    static {
        try {
            WGS84_XY = CRS.getAuthorityFactory((boolean)true).createCoordinateReferenceSystem("EPSG:4326");
        }
        catch (Exception ex) {
            LOG.error("Unable to create longitude-first WGS84 CRS", (Throwable)ex);
            throw new RuntimeException("Could not create longitude-first WGS84 coordinate reference system.");
        }
    }
}

