/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.geometry;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class DlugoszVarLenIntPacker {
    public static byte[] pack(int[] arr) {
        if (arr == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(arr.length);
        for (int i : arr) {
            if (i >= -64 && i <= 63) {
                int ui = i + 64;
                baos.write(ui);
                continue;
            }
            if (i >= -8192 && i <= 8191) {
                int ui = i + 8192;
                baos.write(0x80 | ui >> 8);
                baos.write(ui & 0xFF);
                continue;
            }
            if (i >= -1048576 && i <= 1048575) {
                int ui = i + 0x100000;
                baos.write(0xC0 | ui >> 16);
                baos.write(ui >> 8 & 0xFF);
                baos.write(ui & 0xFF);
                continue;
            }
            if (i >= -67108864 && i <= 0x3FFFFFF) {
                int ui = i + 0x4000000;
                baos.write(0xE0 | ui >> 24);
                baos.write(ui >> 16 & 0xFF);
                baos.write(ui >> 8 & 0xFF);
                baos.write(ui & 0xFF);
                continue;
            }
            long ui = (long)i + 0x80000000L;
            baos.write((int)(0xE8L | ui >> 32));
            baos.write((int)(ui >> 24 & 0xFFL));
            baos.write((int)(ui >> 16 & 0xFFL));
            baos.write((int)(ui >> 8 & 0xFFL));
            baos.write((int)(ui & 0xFFL));
        }
        return baos.toByteArray();
    }

    public static int[] unpack(byte[] arr) {
        if (arr == null) {
            return null;
        }
        ArrayList<Integer> retval = new ArrayList<Integer>(arr.length);
        int i = 0;
        while (i < arr.length) {
            int v1 = arr[i] & 0xFF;
            ++i;
            if ((v1 & 0x80) == 0) {
                int sv = (v1 & 0x7F) - 64;
                retval.add(sv);
                continue;
            }
            if ((v1 & 0xC0) == 128) {
                int sv = ((v1 & 0x3F) << 8) + (arr[i] & 0xFF) - 8192;
                ++i;
                retval.add(sv);
                continue;
            }
            if ((v1 & 0xE0) == 192) {
                int sv = ((v1 & 0x1F) << 16) + ((arr[i] & 0xFF) << 8) + (arr[i + 1] & 0xFF) - 0x100000;
                i += 2;
                retval.add(sv);
                continue;
            }
            if ((v1 & 0xF8) == 224) {
                int sv = ((v1 & 0x1F) << 24) + ((arr[i] & 0xFF) << 16) + ((arr[i + 1] & 0xFF) << 8) + (arr[i + 2] & 0xFF) - 0x4000000;
                i += 3;
                retval.add(sv);
                continue;
            }
            long sv = (((long)v1 & 0x1FL) << 32) + (long)((arr[i] & 0xFF) << 24) + (long)((arr[i + 1] & 0xFF) << 16) + (long)((arr[i + 2] & 0xFF) << 8) + (long)(arr[i + 3] & 0xFF) - 0x80000000L;
            i += 4;
            retval.add((int)sv);
        }
        int[] bufret = new int[retval.size()];
        i = 0;
        Iterator iterator = retval.iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            bufret[i++] = v;
        }
        return bufret;
    }
}

