/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.application;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OTPFeature {
    APIBikeRental(true, false, "Enable the bike rental endpoint."),
    APIServerInfo(true, false, "Enable the server info endpoint."),
    APIGraphInspectorTile(true, false, "Enable the inspector  endpoint for graph information for inspection/debugging purpose."),
    APIUpdaterStatus(true, false, "Enable endpoint for graph updaters status."),
    ConsiderPatternsForDirectTransfers(true, false, "Enable limiting transfers so that there is only a single transfer to each pattern."),
    DebugClient(true, false, "Enable the debug web client located at the root of the web server."),
    FloatingBike(true, false, "Enable floating bike routing."),
    MinimumTransferTimeIsDefinitive(false, false, "If the minimum transfer time is a lower bound (default) or the definitive time for the transfer. Set this to `true` if you want to set a transfer time lower than what OTP derives from OSM data."),
    OptimizeTransfers(true, false, "OTP will inspect all itineraries found and optimize where (which stops) the transfer will happen. Waiting time, priority and guaranteed transfers are taken into account."),
    ParallelRouting(false, false, "Enable performing parts of the trip planning in parallel."),
    TransferConstraints(true, false, "Enforce transfers to happen according to the _transfers.txt_(GTFS) and Interchanges(NeTEx). Turing this _off_ will increase the routing performance a little."),
    ActuatorAPI(false, true, "Endpoint for actuators (service health status)."),
    AsyncGraphQLFetchers(false, false, "Whether the @async annotation in the GraphQL schema should lead to the fetch being executed asynchronously. This allows batch or alias queries to run in parallel at the cost of consuming extra threads."),
    DataOverlay(false, true, "Enable usage of data overlay when calculating costs for the street network."),
    FaresV2(false, true, "Enable import of GTFS-Fares v2 data."),
    FlexRouting(false, true, "Enable FLEX routing."),
    GoogleCloudStorage(false, true, "Enable Google Cloud Storage integration."),
    RealtimeResolver(false, true, "When routing with ignoreRealtimeUpdates=true, add an extra step which populates results with realtime data"),
    ReportApi(false, true, "Enable the report API."),
    RestAPIPassInDefaultConfigAsJson(false, false, "Enable a default RouteRequest to be passed in as JSON on the REST API - FOR DEBUGGING ONLY!"),
    SandboxAPIGeocoder(false, true, "Enable the Geocoder API."),
    SandboxAPILegacyGraphQLApi(false, true, "Enable (GTFS) GraphQL API."),
    SandboxAPIMapboxVectorTilesApi(false, true, "Enable Mapbox vector tiles API."),
    SandboxAPIParkAndRideApi(false, true, "Enable park-and-ride endpoint."),
    SandboxAPITransmodelApi(false, true, "Enable Entur Transmodel(NeTEx) GraphQL API."),
    SandboxAPITravelTime(false, true, "Enable the isochrone/travel time surface API."),
    TransferAnalyzer(false, true, "Analyze transfers during graph build."),
    VehicleToStopHeuristics(false, true, "Enable improved heuristic for park-and-ride queries.");

    private static final Object TEST_LOCK;
    private static final Logger LOG;
    private final boolean enabledByDefault;
    private final boolean sandbox;
    private boolean enabled;
    private final String doc;

    private OTPFeature(boolean defaultEnabled, boolean sandbox, String doc) {
        this.enabledByDefault = defaultEnabled;
        this.enabled = defaultEnabled;
        this.sandbox = sandbox;
        this.doc = doc;
    }

    public static void enableFeatures(Map<OTPFeature, Boolean> map) {
        map.forEach(OTPFeature::set);
    }

    public static void logFeatureSetup() {
        LOG.info("Features turned on: \n\t{}", (Object)OTPFeature.valuesAsString(true));
        LOG.info("Features turned off: \n\t{}", (Object)OTPFeature.valuesAsString(false));
    }

    public void testOn(Runnable task) {
        this.testEnabled(true, task);
    }

    public void testOff(Runnable task) {
        this.testEnabled(false, task);
    }

    public boolean isOn() {
        return this.enabled;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public boolean isOff() {
        return !this.enabled;
    }

    public <T> T isOnElseNull(Supplier<T> supplier) {
        return this.isOn() ? (T)supplier.get() : null;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public String doc() {
        return this.doc;
    }

    private void set(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEnabled(boolean enabled, Runnable task) {
        Object object = TEST_LOCK;
        synchronized (object) {
            boolean originalValue = this.enabled;
            try {
                this.set(enabled);
                task.run();
            }
            finally {
                this.set(originalValue);
            }
        }
    }

    private static String valuesAsString(boolean enabled) {
        return Arrays.stream(OTPFeature.values()).filter(it -> it.enabled == enabled).map(Enum::name).collect(Collectors.joining("\n\t"));
    }

    static {
        TEST_LOCK = new Object();
        LOG = LoggerFactory.getLogger(OTPFeature.class);
    }
}

