/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicletostopheuristics;

import java.util.Collection;
import java.util.function.Function;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;

public class BikeToStopSkipEdgeStrategy
implements SkipEdgeStrategy<State, Edge> {
    private static final int LIMIT = 100;
    private static final double MAX_FACTOR = 1.2;
    private final Function<RegularStop, Collection<Trip>> getTripsForStop;
    int numberOfBikeableTripsReached = 0;
    double distanceLimit = Double.MAX_VALUE;

    public BikeToStopSkipEdgeStrategy(Function<RegularStop, Collection<Trip>> getTripsForStop) {
        this.getTripsForStop = getTripsForStop;
    }

    public static boolean bikeAccessForTrip(Trip trip) {
        if (trip.getBikesAllowed() != BikeAccess.UNKNOWN) {
            return trip.getBikesAllowed() == BikeAccess.ALLOWED;
        }
        return trip.getRoute().getBikesAllowed() == BikeAccess.ALLOWED;
    }

    @Override
    public boolean shouldSkipEdge(State current, Edge edge) {
        Vertex vertex = current.getVertex();
        if (vertex instanceof TransitStopVertex) {
            TransitStopVertex stopVertex = (TransitStopVertex)vertex;
            if (this.distanceLimit == Double.MAX_VALUE) {
                this.numberOfBikeableTripsReached = (int)((long)this.numberOfBikeableTripsReached + this.getTripsForStop.apply(stopVertex.getStop()).stream().filter(BikeToStopSkipEdgeStrategy::bikeAccessForTrip).count());
                if (this.numberOfBikeableTripsReached >= 100) {
                    this.distanceLimit = current.getWalkDistance() * 1.2;
                }
            }
        }
        return current.getWalkDistance() > this.distanceLimit;
    }
}

