/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.hslpark;

import com.fasterxml.jackson.databind.JsonNode;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkPatch;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkToVehicleParkingMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HslParkUtilizationToPatchMapper {
    private static final Logger log = LoggerFactory.getLogger(HslParkUtilizationToPatchMapper.class);
    private final String feedId;

    public HslParkUtilizationToPatchMapper(String feedId) {
        this.feedId = feedId;
    }

    public HslParkPatch parseUtilization(JsonNode jsonNode) {
        FeedScopedId vehicleParkId = HslParkToVehicleParkingMapper.createIdForNode(jsonNode, "facilityId", this.feedId);
        try {
            String capacityType = jsonNode.path("capacityType").asText();
            Integer spacesAvailable = HslParkToVehicleParkingMapper.parseIntegerValue(jsonNode, "spacesAvailable");
            return new HslParkPatch(vehicleParkId, capacityType, spacesAvailable);
        }
        catch (Exception e) {
            log.warn("Error parsing park utilization {}", (Object)vehicleParkId, (Object)e);
            return null;
        }
    }
}

