/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehicleparkings;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingAndGroup;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingGroup;

public class DigitransitVehicleParkingGroupPropertyMapper
extends PropertyMapper<VehicleParkingAndGroup> {
    private final I18NStringMapper i18NStringMapper;

    public DigitransitVehicleParkingGroupPropertyMapper(Locale locale) {
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    public static DigitransitVehicleParkingGroupPropertyMapper create(Locale locale) {
        return new DigitransitVehicleParkingGroupPropertyMapper(locale);
    }

    @Override
    protected Collection<KeyValue> map(VehicleParkingAndGroup parkingAndGroup) {
        VehicleParkingGroup group = parkingAndGroup.vehicleParkingGroup();
        String parking = JSONArray.toJSONString(parkingAndGroup.vehicleParking().stream().map((? super T vehicleParkingPlace) -> {
            JSONObject parkingObject = new JSONObject();
            parkingObject.put((Object)"carPlaces", (Object)vehicleParkingPlace.hasCarPlaces());
            parkingObject.put((Object)"bicyclePlaces", (Object)vehicleParkingPlace.hasBicyclePlaces());
            parkingObject.put((Object)"id", (Object)vehicleParkingPlace.getId().toString());
            parkingObject.put((Object)"name", (Object)this.i18NStringMapper.mapToApi(vehicleParkingPlace.getName()));
            return parkingObject;
        }).toList());
        return List.of(new KeyValue("id", group.id().toString()), new KeyValue("name", this.i18NStringMapper.mapToApi(group.name())), new KeyValue("vehicleParking", parking));
    }
}

