/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime.geometry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.traveltime.geometry.DelaunayEdge;
import org.opentripplanner.ext.traveltime.geometry.DelaunayPoint;
import org.opentripplanner.ext.traveltime.geometry.DelaunayTriangulation;
import org.opentripplanner.ext.traveltime.geometry.SparseMatrix;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.ext.traveltime.geometry.ZSamplePoint;

public final class SparseMatrixZSampleGrid<TZ>
implements ZSampleGrid<TZ>,
DelaunayTriangulation<TZ> {
    private final double dX;
    private final double dY;
    private final Coordinate center;
    private final SparseMatrix<SparseMatrixSamplePoint> allSamples;
    private List<GridDelaunayEdge> triangulation = null;

    public SparseMatrixZSampleGrid(int chunkSize, int totalSize, double dX, double dY, Coordinate center) {
        this.center = center;
        this.dX = dX;
        this.dY = dY;
        this.allSamples = new SparseMatrix(chunkSize, totalSize);
    }

    @Override
    public ZSamplePoint<TZ> getOrCreate(int x, int y) {
        SparseMatrixSamplePoint Aleft;
        SparseMatrixSamplePoint Aright;
        SparseMatrixSamplePoint Adown;
        SparseMatrixSamplePoint A = this.allSamples.get(x, y);
        if (A != null) {
            return A;
        }
        A = new SparseMatrixSamplePoint();
        A.x = x;
        A.y = y;
        A.z = null;
        SparseMatrixSamplePoint Aup = this.allSamples.get(x, y + 1);
        if (Aup != null) {
            Aup.down = A;
            A.up = Aup;
        }
        if ((Adown = this.allSamples.get(x, y - 1)) != null) {
            Adown.up = A;
            A.down = Adown;
        }
        if ((Aright = this.allSamples.get(x + 1, y)) != null) {
            Aright.left = A;
            A.right = Aright;
        }
        if ((Aleft = this.allSamples.get(x - 1, y)) != null) {
            Aleft.right = A;
            A.left = Aleft;
        }
        this.allSamples.put(x, y, A);
        return A;
    }

    @Override
    @Nonnull
    public Iterator<ZSamplePoint<TZ>> iterator() {
        return new Iterator<ZSamplePoint<TZ>>(){
            private final Iterator<SparseMatrixSamplePoint> iterator;
            {
                this.iterator = SparseMatrixZSampleGrid.this.allSamples.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ZSamplePoint<TZ> next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public Coordinate getCoordinates(ZSamplePoint<TZ> point) {
        return new Coordinate((double)point.getX() * this.dX + this.center.x, (double)point.getY() * this.dY + this.center.y);
    }

    @Override
    public int[] getLowerLeftIndex(Coordinate C) {
        return new int[]{(int)Math.round((C.x - this.center.x - this.dX / 2.0) / this.dX), (int)Math.round((C.y - this.center.y - this.dY / 2.0) / this.dY)};
    }

    @Override
    public Coordinate getCenter() {
        return this.center;
    }

    @Override
    public Coordinate getCellSize() {
        return new Coordinate(this.dX, this.dY);
    }

    @Override
    public int getXMin() {
        return this.allSamples.xMin;
    }

    @Override
    public int getXMax() {
        return this.allSamples.xMax;
    }

    @Override
    public int getYMin() {
        return this.allSamples.yMin;
    }

    @Override
    public int getYMax() {
        return this.allSamples.yMax;
    }

    @Override
    public int size() {
        return this.allSamples.size();
    }

    @Override
    public int edgesCount() {
        if (this.triangulation == null) {
            this.delaunify();
        }
        return this.triangulation.size();
    }

    @Override
    public Iterable<? extends DelaunayEdge<TZ>> edges() {
        if (this.triangulation == null) {
            this.delaunify();
        }
        return this.triangulation;
    }

    private void delaunify() {
        this.triangulation = new ArrayList<GridDelaunayEdge>(this.allSamples.size() * 3);
        for (SparseMatrixSamplePoint A : this.allSamples) {
            SparseMatrixSamplePoint B = (SparseMatrixSamplePoint)A.right();
            SparseMatrixSamplePoint D = (SparseMatrixSamplePoint)A.up();
            SparseMatrixSamplePoint C = (SparseMatrixSamplePoint)(B != null ? B.up() : (D != null ? D.right() : null));
            if (B != null) {
                this.triangulation.add(new GridDelaunayEdge(A, B, 1));
            }
            if (D != null) {
                this.triangulation.add(new GridDelaunayEdge(A, D, 0));
            }
            if (C == null) continue;
            this.triangulation.add(new GridDelaunayEdge(A, C, 2));
        }
        for (GridDelaunayEdge e : this.triangulation) {
            switch (e.type) {
                case 1: {
                    e.ccw1 = e.B.eUp;
                    e.ccw2 = e.A.eUpRight;
                    e.cw1 = e.A.down == null ? null : e.A.down.eUpRight;
                    e.cw2 = e.A.down == null ? null : e.A.down.eUp;
                    break;
                }
                case 0: {
                    e.ccw1 = e.A.left == null ? null : e.A.left.eUpRight;
                    e.ccw2 = e.A.left == null ? null : e.A.left.eRight;
                    e.cw1 = e.B.eRight;
                    e.cw2 = e.A.eUpRight;
                    break;
                }
                case 2: {
                    e.ccw1 = e.A.up == null ? null : e.A.up.eRight;
                    e.ccw2 = e.A.eUp;
                    e.cw1 = e.A.right == null ? null : e.A.right.eUp;
                    e.cw2 = e.A.eRight;
                }
            }
        }
    }

    @Override
    public DelaunayTriangulation<TZ> delaunayTriangulate() {
        return this;
    }

    private final class SparseMatrixSamplePoint
    implements ZSamplePoint<TZ>,
    DelaunayPoint<TZ> {
        private int x;
        private int y;
        private TZ z;
        private SparseMatrixSamplePoint up;
        private SparseMatrixSamplePoint down;
        private SparseMatrixSamplePoint right;
        private SparseMatrixSamplePoint left;
        private GridDelaunayEdge eUp;
        private GridDelaunayEdge eUpRight;
        private GridDelaunayEdge eRight;

        private SparseMatrixSamplePoint() {
        }

        @Override
        public ZSamplePoint<TZ> up() {
            return this.up;
        }

        @Override
        public ZSamplePoint<TZ> down() {
            return this.down;
        }

        @Override
        public ZSamplePoint<TZ> right() {
            return this.right;
        }

        @Override
        public ZSamplePoint<TZ> left() {
            return this.left;
        }

        @Override
        public Coordinate getCoordinates() {
            return SparseMatrixZSampleGrid.this.getCoordinates(this);
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public TZ getZ() {
            return this.z;
        }

        @Override
        public void setZ(TZ z) {
            this.z = z;
        }
    }

    private final class GridDelaunayEdge
    implements DelaunayEdge<TZ> {
        private static final int TYPE_VERTICAL = 0;
        private static final int TYPE_HORIZONTAL = 1;
        private static final int TYPE_DIAGONAL = 2;
        private boolean processed;
        private final SparseMatrixSamplePoint A;
        private final SparseMatrixSamplePoint B;
        private GridDelaunayEdge ccw1;
        private GridDelaunayEdge ccw2;
        private GridDelaunayEdge cw1;
        private GridDelaunayEdge cw2;
        private final int type;

        private GridDelaunayEdge(SparseMatrixSamplePoint A, SparseMatrixSamplePoint B, int type) {
            this.A = A;
            this.B = B;
            switch (type) {
                case 1: {
                    A.eRight = this;
                    break;
                }
                case 0: {
                    A.eUp = this;
                    break;
                }
                case 2: {
                    A.eUpRight = this;
                }
            }
            this.type = type;
        }

        @Override
        public DelaunayPoint<TZ> getA() {
            return this.A;
        }

        @Override
        public DelaunayPoint<TZ> getB() {
            return this.B;
        }

        @Override
        public DelaunayEdge<TZ> getEdge1(boolean ccw) {
            return ccw ? this.ccw1 : this.cw1;
        }

        @Override
        public DelaunayEdge<TZ> getEdge2(boolean ccw) {
            return ccw ? this.ccw2 : this.cw2;
        }

        @Override
        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public String toString() {
            return "<GridDelaunayEdge " + this.A.getCoordinates() + "->" + this.B.getCoordinates() + ">";
        }
    }
}

