/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime.geometry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SparseMatrix<T>
implements Iterable<T> {
    private int shift = 0;
    private final int mask;
    private final Map<Key, T[]> chunks;
    int size = 0;
    int matSize;
    int chunkSize;
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;

    public SparseMatrix(int chunkSize, int totalSize) {
        this.chunkSize = chunkSize;
        this.mask = chunkSize - 1;
        this.matSize = chunkSize * chunkSize;
        while (chunkSize > 1) {
            if (chunkSize % 2 != 0) {
                throw new IllegalArgumentException("Chunk size must be a power of 2");
            }
            chunkSize /= 2;
            ++this.shift;
        }
        this.chunks = new HashMap<Key, T[]>(totalSize / this.matSize * 4);
        this.xMin = Integer.MAX_VALUE;
        this.yMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        this.yMax = Integer.MIN_VALUE;
    }

    public final T get(int x, int y) {
        T[] ts = this.chunks.get(new Key(x, y, this.shift));
        if (ts == null) {
            return null;
        }
        int index = ((x & this.mask) << this.shift) + (y & this.mask);
        return ts[index];
    }

    public final T put(int x, int y, T t) {
        int index;
        Key key;
        Object[] ts;
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if ((ts = this.chunks.computeIfAbsent(key = new Key(x, y, this.shift), k -> new Object[this.matSize]))[index = ((x & this.mask) << this.shift) + (y & this.mask)] == null) {
            ++this.size;
        }
        ts[index] = t;
        return t;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new SparseMatrixIterator();
    }

    static class Key {
        int x;
        int y;

        public Key(int x, int y, int shift) {
            this.x = x >>> shift;
            this.y = y >>> shift;
        }

        public int hashCode() {
            return this.x ^ this.y;
        }

        public boolean equals(Object other) {
            return other instanceof Key && ((Key)other).x == this.x && ((Key)other).y == this.y;
        }
    }

    private class SparseMatrixIterator
    implements Iterator<T> {
        private final Iterator<T[]> mapIterator;
        private int chunkIndex = -1;
        private T[] chunk = null;

        private SparseMatrixIterator() {
            this.mapIterator = SparseMatrix.this.chunks.values().iterator();
            this.moveToNext();
        }

        @Override
        public boolean hasNext() {
            return this.chunk != null;
        }

        @Override
        public T next() {
            Object t = this.chunk[this.chunkIndex];
            this.moveToNext();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void moveToNext() {
            if (this.chunk == null) {
                T[] TArray = this.chunk = this.mapIterator.hasNext() ? this.mapIterator.next() : null;
                if (this.chunk == null) {
                    return;
                }
            }
            do {
                ++this.chunkIndex;
                if (this.chunkIndex != SparseMatrix.this.matSize) continue;
                this.chunkIndex = 0;
                T[] TArray = this.chunk = this.mapIterator.hasNext() ? this.mapIterator.next() : null;
                if (this.chunk != null) continue;
                return;
            } while (this.chunk[this.chunkIndex] == null);
        }
    }
}

