/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.ext.traveltime.IsochroneData;
import org.opentripplanner.ext.traveltime.IsochroneRenderer;
import org.opentripplanner.ext.traveltime.PostTransitSkipEdgeStrategy;
import org.opentripplanner.ext.traveltime.RasterRenderer;
import org.opentripplanner.ext.traveltime.SampleGridRenderer;
import org.opentripplanner.ext.traveltime.TravelTimeRequest;
import org.opentripplanner.ext.traveltime.TravelTimeStateData;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.raptor.RaptorService;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.raptor.api.response.RaptorResponse;
import org.opentripplanner.raptor.api.response.StopArrivals;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgressRouter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.AccessEgressMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RouteRequestTransitDataProviderFilter;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.framework.DurationForEnum;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TemporaryVerticesContainer;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateData;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.service.TransitService;

@Path(value="/traveltime")
public class TravelTimeResource {
    private final RouteRequest routingRequest;
    private final RaptorRoutingRequestTransitData requestTransitDataProvider;
    private final Instant startTime;
    private final Instant endTime;
    private final ZonedDateTime startOfTime;
    private final TravelTimeRequest traveltimeRequest;
    private final RaptorService<TripSchedule> raptorService;
    private final Graph graph;
    private final TransitService transitService;

    public TravelTimeResource(@Context OtpServerRequestContext serverContext, @QueryParam(value="location") String location, @QueryParam(value="time") String time, @QueryParam(value="cutoff") @DefaultValue(value="60m") List<String> cutoffs, @QueryParam(value="modes") String modes, @QueryParam(value="arriveBy") @DefaultValue(value="false") boolean arriveBy) {
        this.graph = serverContext.graph();
        this.transitService = serverContext.transitService();
        this.routingRequest = serverContext.defaultRouteRequest();
        this.routingRequest.setArriveBy(arriveBy);
        if (modes != null) {
            QualifiedModeSet modeSet = new QualifiedModeSet(modes);
            this.routingRequest.journey().setModes(modeSet.getRequestModes());
            List<MainAndSubMode> transitModes = modeSet.getTransitModes().stream().map(MainAndSubMode::new).toList();
            SelectRequest select = SelectRequest.of().withTransportModes(transitModes).build();
            TransitFilterRequest request = TransitFilterRequest.of().addSelect(select).build();
            this.routingRequest.journey().transit().setFilters(List.of(request));
        }
        DurationForEnum<StreetMode> durationForMode = this.routingRequest.preferences().street().maxAccessEgressDuration();
        this.traveltimeRequest = new TravelTimeRequest(cutoffs.stream().map(DurationUtils::duration).toList(), durationForMode.valueOf(this.getAccessRequest(this.routingRequest).mode()), durationForMode.valueOf(this.getEgressRequest(this.routingRequest).mode()));
        GenericLocation parsedLocation = LocationStringParser.fromOldStyleString(location);
        Instant requestTime = time != null ? Instant.parse(time) : Instant.now();
        this.routingRequest.setDateTime(requestTime);
        if (this.routingRequest.arriveBy()) {
            this.startTime = requestTime.minus(this.traveltimeRequest.maxCutoff);
            this.endTime = requestTime;
            this.routingRequest.setTo(parsedLocation);
        } else {
            this.startTime = requestTime;
            this.endTime = this.startTime.plus(this.traveltimeRequest.maxCutoff);
            this.routingRequest.setFrom(parsedLocation);
        }
        ZoneId zoneId = this.transitService.getTimeZone();
        LocalDate startDate = LocalDate.ofInstant(this.startTime, zoneId);
        LocalDate endDate = LocalDate.ofInstant(this.endTime, zoneId);
        this.startOfTime = ServiceDateUtils.asStartOfService(startDate, zoneId);
        this.requestTransitDataProvider = new RaptorRoutingRequestTransitData(this.transitService.getRealtimeTransitLayer(), this.startOfTime, 0, (int)Period.between(startDate, endDate).get(ChronoUnit.DAYS), new RouteRequestTransitDataProviderFilter(this.routingRequest), this.routingRequest);
        this.raptorService = new RaptorService<TripSchedule>(serverContext.raptorConfig());
    }

    @GET
    @Path(value="/isochrone")
    @Produces(value={"application/json"})
    public Response getIsochrones() {
        ZSampleGrid<WTWD> sampleGrid = this.getSampleGrid();
        List<IsochroneData> isochrones = IsochroneRenderer.renderIsochrones(sampleGrid, this.traveltimeRequest);
        SimpleFeatureCollection features = IsochroneRenderer.makeContourFeatures(isochrones);
        StreamingOutput out = outputStream -> {
            try (GeoJSONWriter geoJSONWriter = new GeoJSONWriter(outputStream);){
                geoJSONWriter.writeFeatureCollection(features);
            }
        };
        return Response.ok().entity((Object)out).build();
    }

    @GET
    @Path(value="/surface")
    @Produces(value={"image/tiff"})
    public Response getSurface() {
        ZSampleGrid<WTWD> sampleGrid = this.getSampleGrid();
        StreamingOutput streamingOutput = RasterRenderer.createGeoTiffRaster(sampleGrid);
        return Response.ok().entity((Object)streamingOutput).build();
    }

    private ZSampleGrid<WTWD> getSampleGrid() {
        try (TemporaryVerticesContainer temporaryVertices = new TemporaryVerticesContainer(this.graph, this.routingRequest, this.getAccessRequest(this.routingRequest).mode(), StreetMode.NOT_SET);){
            Collection<DefaultAccessEgress> accessList = this.getAccess(temporaryVertices);
            StopArrivals arrivals = this.route(accessList).getArrivals();
            ShortestPathTree<State, Edge, Vertex> spt = this.getShortestPathTree(temporaryVertices, arrivals);
            ZSampleGrid<WTWD> zSampleGrid = SampleGridRenderer.getSampleGrid(spt, this.traveltimeRequest);
            return zSampleGrid;
        }
    }

    private Collection<DefaultAccessEgress> getAccess(TemporaryVerticesContainer temporaryVertices) {
        Collection<NearbyStop> accessStops = AccessEgressRouter.streetSearch(this.routingRequest, temporaryVertices, this.transitService, this.getAccessRequest(this.routingRequest), null, this.routingRequest.arriveBy(), this.traveltimeRequest.maxAccessDuration);
        return new AccessEgressMapper().mapNearbyStops(accessStops, this.routingRequest.arriveBy());
    }

    private ShortestPathTree<State, Edge, Vertex> getShortestPathTree(TemporaryVerticesContainer temporaryVertices, StopArrivals arrivals) {
        return ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(new PostTransitSkipEdgeStrategy(this.traveltimeRequest.maxEgressDuration, this.routingRequest.dateTime(), this.routingRequest.arriveBy()))).setRequest(this.routingRequest).setStreetRequest(this.getEgressRequest(this.routingRequest)).setVerticesContainer(temporaryVertices).setDominanceFunction(new DominanceFunctions.EarliestArrival())).setInitialStates(this.getInitialStates(arrivals, temporaryVertices))).getShortestPathTree();
    }

    private List<State> getInitialStates(StopArrivals arrivals, TemporaryVerticesContainer temporaryVertices) {
        ArrayList<State> initialStates = new ArrayList<State>();
        StreetSearchRequest directStreetSearchRequest = StreetSearchRequestMapper.map(this.routingRequest).withMode(this.routingRequest.journey().direct().mode()).withArriveBy(this.routingRequest.arriveBy()).build();
        List<StateData> directStateDatas = StateData.getInitialStateDatas(directStreetSearchRequest);
        Set<Vertex> vertices = this.routingRequest.arriveBy() ? temporaryVertices.getToVertices() : temporaryVertices.getFromVertices();
        for (Vertex vertex : vertices) {
            for (StateData stateData : directStateDatas) {
                initialStates.add(new State(vertex, this.startTime, stateData, directStreetSearchRequest));
            }
        }
        StreetSearchRequest egressStreetSearchRequest = StreetSearchRequestMapper.map(this.routingRequest).withMode(this.getEgressRequest(this.routingRequest).mode()).withArriveBy(this.routingRequest.arriveBy()).build();
        for (RegularStop stop : this.transitService.listRegularStops()) {
            int index = stop.getIndex();
            if (!arrivals.reachedByTransit(index)) continue;
            int arrivalTime = arrivals.bestTransitArrivalTime(index);
            TransitStopVertex v = this.graph.getStopVertexForStopId(stop.getId());
            if (v == null) continue;
            Instant time = this.startOfTime.plusSeconds(arrivalTime).toInstant();
            List<StateData> egressStateDatas = StateData.getInitialStateDatas(egressStreetSearchRequest, mode -> new TravelTimeStateData((StreetMode)((Object)mode), time.getEpochSecond()));
            for (StateData stopStateData : egressStateDatas) {
                State s = new State(v, time, stopStateData, directStreetSearchRequest);
                s.weight = this.routingRequest.arriveBy() ? (double)time.until(this.endTime, ChronoUnit.SECONDS) : (double)this.startTime.until(time, ChronoUnit.SECONDS);
                initialStates.add(s);
            }
        }
        return initialStates;
    }

    private RaptorResponse<TripSchedule> route(Collection<? extends RaptorAccessEgress> accessList) {
        RaptorRequestBuilder builder = new RaptorRequestBuilder();
        builder.profile(RaptorProfile.BEST_TIME).searchParams().earliestDepartureTime(ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, this.startTime)).latestArrivalTime(ServiceDateUtils.secondsSinceStartOfTime(this.startOfTime, this.endTime)).searchOneIterationOnly().timetable(false).allowEmptyAccessEgressPaths(true).constrainedTransfers(false);
        if (this.routingRequest.arriveBy()) {
            builder.searchDirection(SearchDirection.REVERSE).searchParams().addEgressPaths(accessList);
        } else {
            builder.searchDirection(SearchDirection.FORWARD).searchParams().addAccessPaths(accessList);
        }
        return this.raptorService.route(builder.build(), this.requestTransitDataProvider);
    }

    private StreetRequest getAccessRequest(RouteRequest accessRequest) {
        return this.routingRequest.arriveBy() ? accessRequest.journey().egress() : accessRequest.journey().access();
    }

    private StreetRequest getEgressRequest(RouteRequest accessRequest) {
        return this.routingRequest.arriveBy() ? accessRequest.journey().access() : accessRequest.journey().egress();
    }
}

