/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import jakarta.ws.rs.core.StreamingOutput;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.ext.traveltime.geometry.ZSamplePoint;

public class RasterRenderer {
    static StreamingOutput createGeoTiffRaster(ZSampleGrid<WTWD> sampleGrid) {
        int minX = sampleGrid.getXMin();
        int minY = sampleGrid.getYMin();
        int maxY = sampleGrid.getYMax();
        int width = sampleGrid.getXMax() - minX + 1;
        int height = maxY - minY + 1;
        Coordinate center = sampleGrid.getCenter();
        double resX = sampleGrid.getCellSize().x;
        double resY = sampleGrid.getCellSize().y;
        WritableRaster raster = RasterFactory.createBandedRaster((int)3, (int)width, (int)height, (int)1, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            dataBuffer.setElem(i, Integer.MIN_VALUE);
        }
        for (ZSamplePoint zSamplePoint : sampleGrid) {
            WTWD z = (WTWD)zSamplePoint.getZ();
            raster.setSample(zSamplePoint.getX() - minX, maxY - zSamplePoint.getY(), 0, z.wTime / z.w);
        }
        Envelope2D geom = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, width, height), (MathTransform)new AffineTransform2D(resX, 0.0, 0.0, resY, center.x + resX * (double)minX, center.y + resY * (double)minY), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getEnvelope2D();
        GridCoverage2D gridCoverage2D = new GridCoverageFactory().create((CharSequence)"traveltime", raster, (Envelope)geom);
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
        params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        return outputStream -> {
            GeoTiffWriter writer = new GeoTiffWriter((Object)outputStream);
            writer.write((GridCoverage)gridCoverage, params.values().toArray(new GeneralParameterValue[1]));
            writer.dispose();
            outputStream.close();
        };
    }
}

