/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.time.Duration;
import java.time.Instant;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.ext.traveltime.TravelTimeStateData;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateData;

public class PostTransitSkipEdgeStrategy
implements SkipEdgeStrategy<State, Edge> {
    private final long maxDurationSeconds;
    private final long departureTime;
    private final boolean arriveBy;

    public PostTransitSkipEdgeStrategy(Duration maxEgressTime, Instant departureTime, boolean arriveBy) {
        this.maxDurationSeconds = maxEgressTime.toSeconds();
        this.departureTime = departureTime.getEpochSecond();
        this.arriveBy = arriveBy;
    }

    @Override
    public boolean shouldSkipEdge(State current, Edge edge) {
        long postTransitDepartureTime;
        StateData stateData = current.stateData;
        if (stateData instanceof TravelTimeStateData) {
            TravelTimeStateData travelTimeStateData = (TravelTimeStateData)stateData;
            postTransitDepartureTime = travelTimeStateData.postTransitDepartureTime;
        } else {
            postTransitDepartureTime = this.departureTime;
        }
        long duration = this.arriveBy ? postTransitDepartureTime - current.getTimeSeconds() : current.getTimeSeconds() - postTransitDepartureTime;
        return duration > this.maxDurationSeconds;
    }
}

