/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.AssertException;
import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.framework.geometry.EncodedPolyline;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.TripTimesShortHelper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;

public class ServiceJourneyType {
    private static final String NAME = "ServiceJourney";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("ServiceJourney");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType linkGeometryType, GraphQLOutputType operatorType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLOutputType lineType, GraphQLOutputType ptSituationElementType, GraphQLOutputType journeyPatternType, GraphQLOutputType estimatedCallType, GraphQLOutputType timetabledPassingTimeType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("A planned vehicle journey with passengers.").field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)lineType)).dataFetcher(environment -> ServiceJourneyType.trip(environment).getRoute()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("activeDates").withDirective(gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)gqlUtil.dateScalar))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getCalendarService().getServiceDatesForServiceId(ServiceJourneyType.trip(environment).getServiceId()).stream().sorted().collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportMode").type((GraphQLOutputType)EnumTypes.TRANSPORT_MODE).dataFetcher(environment -> ServiceJourneyType.trip(environment).getMode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").type((GraphQLOutputType)EnumTypes.TRANSPORT_SUBMODE).dataFetcher(environment -> TransmodelTransportSubmode.fromValue(ServiceJourneyType.trip(environment).getNetexSubMode())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("publicCode").type((GraphQLOutputType)Scalars.GraphQLString).description("Publicly announced code for service journey, differentiating it from other service journeys for the same line.").dataFetcher(environment -> ServiceJourneyType.trip(environment).getShortName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("privateCode").type((GraphQLOutputType)Scalars.GraphQLString).description("For internal use by operators.").dataFetcher(environment -> ServiceJourneyType.trip(environment).getNetexInternalPlanningCode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").type(operatorType).dataFetcher(environment -> ServiceJourneyType.trip(environment).getOperator()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directionType").type((GraphQLOutputType)EnumTypes.DIRECTION_TYPE).dataFetcher(environment -> ServiceJourneyType.trip(environment).getDirection()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceAlteration").deprecate("The service journey alteration will be moved out of SJ and grouped together with the SJ and date. In Netex this new type is called DatedServiceJourney. We will create artificial DSJs for the old SJs.").type((GraphQLOutputType)EnumTypes.SERVICE_ALTERATION).dataFetcher(environment -> ServiceJourneyType.trip(environment).getNetexAlteration()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("wheelchairAccessible").type((GraphQLOutputType)EnumTypes.WHEELCHAIR_BOARDING).dataFetcher(environment -> ServiceJourneyType.trip(environment).getWheelchairBoarding()).description("Whether service journey is accessible with wheelchair.").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikesAllowed").type((GraphQLOutputType)EnumTypes.BIKES_ALLOWED).description("Whether bikes are allowed on service journey.").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("journeyPattern").description("JourneyPattern for the service journey, according to scheduled data. If the ServiceJourney is not included in the scheduled data, null is returned.").type(journeyPatternType).dataFetcher(env -> GqlUtil.getTransitService(env).getPatternForTrip(ServiceJourneyType.trip(env))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Quays visited by service journey, according to scheduled data. If the ServiceJourney is not included in the scheduled data, an empty list is returned.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).argument(GraphQLArgument.newArgument().name("first").description("Only fetch the first n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("last").description("Only fetch the last n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).dataFetcher(environment -> {
            Integer first = (Integer)environment.getArgument("first");
            Integer last = (Integer)environment.getArgument("last");
            TransitService transitService = GqlUtil.getTransitService(environment);
            TripPattern tripPattern = transitService.getPatternForTrip(ServiceJourneyType.trip(environment));
            if (tripPattern == null) {
                return List.of();
            }
            List<StopLocation> stops = tripPattern.getStops();
            if (first != null && last != null) {
                throw new AssertException("Both first and last can't be defined simultaneously.");
            }
            if (first != null) {
                if (first > stops.size()) {
                    return stops.subList(0, first);
                }
            } else if (last != null && last > stops.size()) {
                return stops.subList(stops.size() - last, stops.size());
            }
            return stops;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("passingTimes").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)timetabledPassingTimeType))).withDirective(gqlUtil.timingData).description("Returns scheduled passing times only - without realtime-updates, for realtime-data use 'estimatedCalls'").dataFetcher(env -> {
            Trip trip = ServiceJourneyType.trip(env);
            TripPattern tripPattern = GqlUtil.getTransitService(env).getPatternForTrip(trip);
            if (tripPattern == null) {
                return List.of();
            }
            return TripTimeOnDate.fromTripTimes(tripPattern.getScheduledTimetable(), trip);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("estimatedCalls").type((GraphQLOutputType)new GraphQLList((GraphQLType)estimatedCallType)).withDirective(gqlUtil.timingData).description("Returns scheduled passingTimes for this ServiceJourney for a given date, updated with realtime-updates (if available). NB! This takes a date as argument (default=today) and returns estimatedCalls for that date and should only be used if the date is known when creating the request. For fetching estimatedCalls for a given trip.leg, use leg.serviceJourneyEstimatedCalls instead.").argument(GraphQLArgument.newArgument().name("date").type((GraphQLInputType)gqlUtil.dateScalar).description("Date to get estimated calls for. Defaults to today.").build()).dataFetcher(environment -> {
            LocalDate serviceDate = Optional.ofNullable(environment.getArgument("date")).map(LocalDate.class::cast).orElse(LocalDate.now(GqlUtil.getTransitService(environment).getTimeZone()));
            return TripTimesShortHelper.getTripTimesShort(GqlUtil.getTransitService(environment), ServiceJourneyType.trip(environment), serviceDate);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pointsOnLink").type(linkGeometryType).description("Detailed path travelled by service journey. Not available for flexible trips.").dataFetcher(environment -> {
            TripPattern tripPattern = GqlUtil.getTransitService(environment).getPatternForTrip(ServiceJourneyType.trip(environment));
            if (tripPattern == null) {
                return null;
            }
            LineString geometry = tripPattern.getGeometry();
            if (geometry == null) {
                return null;
            }
            return EncodedPolyline.encode((Geometry)geometry);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)noticeType)))).dataFetcher(env -> GqlUtil.getTransitService(env).getNoticesByEntity(ServiceJourneyType.trip(env))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all situations active for the service journey.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getTransitAlertService().getTripAlerts(ServiceJourneyType.trip(environment).getId(), null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").description("Booking arrangements for flexible services.").type(bookingArrangementType).deprecate("BookingArrangements are defined per stop, and can be found under `passingTimes` or `estimatedCalls`").build()).build();
    }

    private static Trip trip(DataFetchingEnvironment environment) {
        return (Trip)environment.getSource();
    }
}

