/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.siri.sx;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.ext.transmodelapi.mapping.SeverityMapper;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.siri.sx.ValidityPeriod;
import org.opentripplanner.ext.transmodelapi.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.service.TransitService;

public class PtSituationElementType {
    private static final String NAME = "PtSituationElement";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("PtSituationElement");

    public static GraphQLObjectType create(GraphQLOutputType authorityType, GraphQLOutputType quayType, GraphQLOutputType stopPlaceType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType multilingualStringType, GraphQLObjectType validityPeriodType, GraphQLObjectType infoLinkType, GraphQLOutputType affectsType, GqlUtil gqlUtil, Relay relay) {
        return GraphQLObjectType.newObject().name(NAME).description("Simple public transport situation element").field(GraphQLFieldDefinition.newFieldDefinition().name("id").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).dataFetcher(environment -> relay.toGlobalId(NAME, ((TransitAlert)environment.getSource()).getId().getId())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").type(authorityType).description("Get affected authority for this situation element").deprecate("Use affects instead").dataFetcher(environment -> GqlUtil.getTransitService(environment).getAgencyForId(((TransitAlert)environment.getSource()).entities().stream().filter(EntitySelector.Agency.class::isInstance).map(EntitySelector.Agency.class::cast).findAny().map(EntitySelector.Agency::agencyId).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).deprecate("Use affects instead").dataFetcher(environment -> {
            TransitService transitService = GqlUtil.getTransitService(environment);
            return ((TransitAlert)environment.getSource()).entities().stream().filter(EntitySelector.Route.class::isInstance).map(EntitySelector.Route.class::cast).map(EntitySelector.Route::routeId).map(transitService::getRouteForId).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)serviceJourneyType))).deprecate("Use affects instead").dataFetcher(environment -> {
            TransitService transitService = GqlUtil.getTransitService(environment);
            return ((TransitAlert)environment.getSource()).entities().stream().filter(EntitySelector.Trip.class::isInstance).map(EntitySelector.Trip.class::cast).map(EntitySelector.Trip::tripId).map(transitService::getTripForId).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).deprecate("Use affects instead").dataFetcher(environment -> {
            TransitService transitService = GqlUtil.getTransitService(environment);
            return ((TransitAlert)environment.getSource()).entities().stream().filter(EntitySelector.Stop.class::isInstance).map(EntitySelector.Stop.class::cast).map(EntitySelector.Stop::stopId).map(transitService::getRegularStop).filter(Objects::nonNull).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlaces").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)stopPlaceType)))).deprecate("Use affects instead").dataFetcher(environment -> {
            TransitService transitService = GqlUtil.getTransitService(environment);
            return ((TransitAlert)environment.getSource()).entities().stream().filter(EntitySelector.Stop.class::isInstance).map(EntitySelector.Stop.class::cast).map(EntitySelector.Stop::stopId).map(transitService::getStationById).filter(Objects::nonNull).map(station -> new MonoOrMultiModalStation((Station)station, transitService.getMultiModalStationForStation((Station)station))).toList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("affects").description("Get all affected entities for the situation").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)affectsType)))).dataFetcher(environment -> ((TransitAlert)environment.getSource()).entities()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("summary").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Summary of situation in all different translations available").dataFetcher(environment -> {
            I18NString headerText = ((TransitAlert)environment.getSource()).headerText();
            if (headerText instanceof TranslatedString) {
                TranslatedString translatedString = (TranslatedString)headerText;
                return translatedString.getTranslations();
            }
            if (headerText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, headerText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Description of situation in all different translations available").dataFetcher(environment -> {
            I18NString descriptionText = ((TransitAlert)environment.getSource()).descriptionText();
            if (descriptionText instanceof TranslatedString) {
                TranslatedString translatedString = (TranslatedString)descriptionText;
                return translatedString.getTranslations();
            }
            if (descriptionText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, descriptionText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("advice").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Advice of situation in all different translations available").dataFetcher(environment -> {
            I18NString adviceText = ((TransitAlert)environment.getSource()).adviceText();
            if (adviceText instanceof TranslatedString) {
                TranslatedString translatedString = (TranslatedString)adviceText;
                return translatedString.getTranslations();
            }
            if (adviceText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, adviceText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("infoLinks").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)infoLinkType))).description("Optional links to more information.").dataFetcher(environment -> {
            List<AlertUrl> siriUrls = ((TransitAlert)environment.getSource()).siriUrls();
            if (!siriUrls.isEmpty()) {
                return siriUrls;
            }
            return null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validityPeriod").type((GraphQLOutputType)validityPeriodType).description("Period this situation is in effect").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            Long startTime = alert.getEffectiveStartDate() != null ? Long.valueOf(alert.getEffectiveStartDate().toEpochMilli()) : null;
            Long endTime = alert.getEffectiveEndDate() != null ? Long.valueOf(alert.getEffectiveEndDate().toEpochMilli()) : null;
            return new ValidityPeriod(startTime, endTime);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("reportType").type((GraphQLOutputType)EnumTypes.REPORT_TYPE).description("ReportType of this situation").dataFetcher(environment -> ((TransitAlert)environment.getSource()).type()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situationNumber").type((GraphQLOutputType)Scalars.GraphQLString).description("Operator's internal id for this situation").dataFetcher(environment -> ((TransitAlert)environment.getSource()).getId().getId()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("severity").type((GraphQLOutputType)EnumTypes.SEVERITY).description("Severity of this situation ").dataFetcher(environment -> SeverityMapper.getTransmodelSeverity(((TransitAlert)environment.getSource()).severity())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("priority").type((GraphQLOutputType)Scalars.GraphQLInt).description("Priority of this situation ").dataFetcher(environment -> ((TransitAlert)environment.getSource()).priority()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("creationTime").type((GraphQLOutputType)gqlUtil.dateTimeScalar).description("Timestamp for when the situation was created.").dataFetcher(environment -> {
            ZonedDateTime creationTime = ((TransitAlert)environment.getSource()).creationTime();
            return creationTime == null ? null : Long.valueOf(creationTime.toInstant().toEpochMilli());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("versionedAtTime").type((GraphQLOutputType)gqlUtil.dateTimeScalar).description("Timestamp when the situation element was updated.").dataFetcher(environment -> {
            ZonedDateTime updatedTime = ((TransitAlert)environment.getSource()).updatedTime();
            return updatedTime == null ? null : Long.valueOf(updatedTime.toInstant().toEpochMilli());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("participant").type((GraphQLOutputType)Scalars.GraphQLString).description("Codespace of the data source.").dataFetcher(environment -> ((TransitAlert)environment.getSource()).siriCodespace()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("reportAuthority").type(authorityType).description("Authority that reported this situation. Always returns the first agency in the codespace").deprecate("Not yet officially supported. May be removed or renamed.").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            String feedId = alert.getId().getFeedId();
            String codespace = alert.siriCodespace();
            if (codespace == null) {
                return null;
            }
            return GqlUtil.getTransitService(environment).getAgencies().stream().filter(agency -> agency.getId().getFeedId().equals(feedId)).filter(agency -> agency.getId().getId().startsWith(codespace)).findFirst().orElse(null);
        }).build()).build();
    }
}

