/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.transmodelapi.TransmodelRequestContext;
import org.opentripplanner.ext.transmodelapi.mapping.FilterMapper;
import org.opentripplanner.ext.transmodelapi.mapping.GenericLocationMapper;
import org.opentripplanner.ext.transmodelapi.mapping.PreferencesMapper;
import org.opentripplanner.ext.transmodelapi.mapping.RequestModesMapper;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.support.DataFetcherDecorator;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class TripRequestMapper {
    public static RouteRequest createRequest(DataFetchingEnvironment environment) {
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = context.getServerContext();
        RouteRequest request = serverContext.defaultRouteRequest();
        DataFetcherDecorator callWith = new DataFetcherDecorator(environment);
        callWith.argument("locale", v -> request.setLocale(Locale.forLanguageTag(v)));
        callWith.argument("from", v -> request.setFrom(GenericLocationMapper.toGenericLocation(v)));
        callWith.argument("to", v -> request.setTo(GenericLocationMapper.toGenericLocation(v)));
        callWith.argument("dateTime", millisSinceEpoch -> request.setDateTime(Instant.ofEpochMilli((Long)millisSinceEpoch)));
        callWith.argument("searchWindow", m -> request.setSearchWindow(Duration.ofMinutes(m.intValue())));
        callWith.argument("pageCursor", request::setPageCursorFromEncoded);
        callWith.argument("timetableView", request::setTimetableView);
        callWith.argument("wheelchairAccessible", request::setWheelchair);
        callWith.argument("numTripPatterns", request::setNumItineraries);
        callWith.argument("arriveBy", request::setArriveBy);
        callWith.argument("preferred.authorities", authorities -> request.journey().transit().setPreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("unpreferred.authorities", authorities -> request.journey().transit().setUnpreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("preferred.lines", lines -> request.journey().transit().setPreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("unpreferred.lines", lines -> request.journey().transit().setUnpreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("whiteListed.rentalNetworks", networks -> request.journey().rental().setAllowedNetworks(Set.copyOf(networks)));
        callWith.argument("banned.rentalNetworks", networks -> request.journey().rental().setBannedNetworks(Set.copyOf(networks)));
        if (GqlUtil.hasArgument(environment, "modes")) {
            request.journey().setModes(RequestModesMapper.mapRequestModes((Map)environment.getArgument("modes")));
        }
        ArrayList<FeedScopedId> bannedTrips = new ArrayList<FeedScopedId>();
        callWith.argument("banned.serviceJourneys", serviceJourneys -> bannedTrips.addAll(TransitIdMapper.mapIDsToDomain(serviceJourneys)));
        if (!bannedTrips.isEmpty()) {
            request.journey().transit().setBannedTrips(bannedTrips);
        }
        if (GqlUtil.hasArgument(environment, "filters")) {
            request.journey().transit().setFilters(FilterMapper.mapFilterNewWay((List)environment.getArgument("filters")));
        } else {
            FilterMapper.mapFilterOldWay(environment, callWith, request);
        }
        request.withPreferences(preferences -> PreferencesMapper.mapPreferences(environment, callWith, preferences));
        return request;
    }
}

