/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.transmodelapi.mapping.SelectRequestMapper;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.support.DataFetcherDecorator;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.routing.api.request.request.filter.TransitFilterRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class FilterMapper {
    FilterMapper() {
    }

    static void mapFilterOldWay(DataFetchingEnvironment environment, DataFetcherDecorator callWith, RouteRequest request) {
        if (!(GqlUtil.hasArgument(environment, "modes") && ((Map)environment.getArgument("modes")).containsKey("transportModes") || GqlUtil.hasArgument(environment, "whiteListed") || GqlUtil.hasArgument(environment, "banned"))) {
            return;
        }
        TransitFilterRequest.Builder filterRequestBuilder = TransitFilterRequest.of();
        ArrayList<FeedScopedId> bannedAgencies = new ArrayList<FeedScopedId>();
        callWith.argument("banned.authorities", authorities -> bannedAgencies.addAll(TransitIdMapper.mapIDsToDomain(authorities)));
        if (!bannedAgencies.isEmpty()) {
            filterRequestBuilder.addNot(SelectRequest.of().withAgencies(bannedAgencies).build());
        }
        ArrayList<FeedScopedId> bannedLines = new ArrayList<FeedScopedId>();
        callWith.argument("banned.lines", lines -> bannedLines.addAll(TransitIdMapper.mapIDsToDomain(lines)));
        if (!bannedLines.isEmpty()) {
            filterRequestBuilder.addNot(SelectRequest.of().withRoutes(bannedLines).build());
        }
        ArrayList<SelectRequest.Builder> selectors = new ArrayList<SelectRequest.Builder>();
        ArrayList<FeedScopedId> whiteListedAgencies = new ArrayList<FeedScopedId>();
        callWith.argument("whiteListed.authorities", authorities -> whiteListedAgencies.addAll(TransitIdMapper.mapIDsToDomain(authorities)));
        if (!whiteListedAgencies.isEmpty()) {
            selectors.add(SelectRequest.of().withAgencies(whiteListedAgencies));
        }
        ArrayList<FeedScopedId> whiteListedLines = new ArrayList<FeedScopedId>();
        callWith.argument("whiteListed.lines", lines -> whiteListedLines.addAll(TransitIdMapper.mapIDsToDomain(lines)));
        if (!whiteListedLines.isEmpty()) {
            selectors.add(SelectRequest.of().withRoutes(whiteListedLines));
        }
        ArrayList<MainAndSubMode> tModes = new ArrayList();
        if (GqlUtil.hasArgument(environment, "modes")) {
            Map modesInput = (Map)environment.getArgument("modes");
            if (modesInput.containsKey("transportModes")) {
                List transportModes = (List)modesInput.get("transportModes");
                if (transportModes.isEmpty()) {
                    request.journey().transit().disable();
                    return;
                }
                for (Map modeWithSubmodes : transportModes) {
                    if (!modeWithSubmodes.containsKey("transportMode")) continue;
                    TransitMode mainMode = (TransitMode)((Object)modeWithSubmodes.get("transportMode"));
                    if (modeWithSubmodes.containsKey("transportSubModes")) {
                        List transportSubModes = (List)modeWithSubmodes.get("transportSubModes");
                        for (TransmodelTransportSubmode submode : transportSubModes) {
                            tModes.add(new MainAndSubMode(mainMode, SubMode.of(submode.getValue())));
                        }
                        continue;
                    }
                    tModes.add(new MainAndSubMode(mainMode));
                }
            } else {
                tModes = MainAndSubMode.all();
            }
        } else {
            tModes = MainAndSubMode.all();
        }
        if (!selectors.isEmpty()) {
            for (SelectRequest.Builder selector : selectors) {
                filterRequestBuilder.addSelect(selector.withTransportModes(tModes).build());
            }
        } else {
            filterRequestBuilder.addSelect(SelectRequest.of().withTransportModes(tModes).build());
        }
        request.journey().transit().setFilters(List.of(filterRequestBuilder.build()));
    }

    static List<TransitFilter> mapFilterNewWay(List<Map<String, ?>> filters) {
        ArrayList<TransitFilter> filterRequests = new ArrayList<TransitFilter>();
        for (Map<String, ?> filterInput : filters) {
            TransitFilterRequest.Builder filterRequestBuilder = TransitFilterRequest.of();
            if (filterInput.containsKey("select")) {
                for (Map selectInput : (List)filterInput.get("select")) {
                    filterRequestBuilder.addSelect(SelectRequestMapper.mapSelectRequest(selectInput));
                }
            }
            if (filterInput.containsKey("not")) {
                for (Map selectInput : (List)filterInput.get("not")) {
                    filterRequestBuilder.addNot(SelectRequestMapper.mapSelectRequest(selectInput));
                }
            }
            filterRequests.add(filterRequestBuilder.build());
        }
        return filterRequests;
    }
}

