/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.schema.GraphQLSchema;
import io.micrometer.core.instrument.Tag;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.opentripplanner.api.json.GraphQLResponseSerializer;
import org.opentripplanner.ext.transmodelapi.TransmodelAPIParameters;
import org.opentripplanner.ext.transmodelapi.TransmodelGraph;
import org.opentripplanner.ext.transmodelapi.TransmodelGraphQLSchema;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/routers/{ignoreRouterId}/transmodel/index")
@Produces(value={"application/json"})
public class TransmodelAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelAPI.class);
    private static GraphQLSchema schema;
    private static Collection<String> tracingHeaderTags;
    private final OtpServerRequestContext serverContext;
    private final TransmodelGraph index;
    private final ObjectMapper deserializer = new ObjectMapper();

    public TransmodelAPI(@Context OtpServerRequestContext serverContext, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.serverContext = serverContext;
        this.index = new TransmodelGraph(schema);
    }

    public static void setUp(TransmodelAPIParameters config, TransitModel transitModel, RouteRequest defaultRouteRequest) {
        if (config.hideFeedId()) {
            TransitIdMapper.setupFixedFeedId(transitModel.getAgencies());
        }
        tracingHeaderTags = config.tracingHeaderTags();
        GqlUtil gqlUtil = new GqlUtil(transitModel.getTimeZone());
        schema = TransmodelGraphQLSchema.create(defaultRouteRequest, gqlUtil);
    }

    @GET
    @Path(value="/live")
    public Response isAlive() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Path(value="/graphql")
    @Consumes(value={"application/json"})
    public Response getGraphQL(HashMap<String, Object> queryParameters, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        Map<String, Object> variables;
        if (queryParameters == null || !queryParameters.containsKey("query")) {
            LOG.debug("No query found in body");
            throw new BadRequestException("No query found in body");
        }
        String query = (String)queryParameters.get("query");
        Object queryVariables = queryParameters.getOrDefault("variables", null);
        String operationName = queryParameters.getOrDefault("operationName", null);
        if (queryVariables instanceof Map) {
            variables = queryVariables;
        } else if (queryVariables instanceof String && !((String)queryVariables).isEmpty()) {
            try {
                variables = (Map)this.deserializer.readValue((String)queryVariables, Map.class);
            }
            catch (IOException e) {
                throw new BadRequestException("Variables must be a valid json object");
            }
        } else {
            variables = new HashMap<String, Object>();
        }
        return this.index.getGraphQLResponse(query, this.serverContext, variables, operationName, maxResolves, TransmodelAPI.getTagsFromHeaders(headers));
    }

    @POST
    @Path(value="/graphql")
    @Consumes(value={"application/graphql"})
    public Response getGraphQL(String query, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        return this.index.getGraphQLResponse(query, this.serverContext, null, null, maxResolves, TransmodelAPI.getTagsFromHeaders(headers));
    }

    @POST
    @Path(value="/graphql/batch")
    @Consumes(value={"application/json"})
    public Response getGraphQLBatch(List<HashMap<String, Object>> queries, @HeaderParam(value="OTPTimeout") @DefaultValue(value="10000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        ArrayList<Callable<ExecutionResult>> futures = new ArrayList<Callable<ExecutionResult>>();
        for (Map map : queries) {
            Map variables;
            if (map.get("variables") instanceof Map) {
                variables = (Map)map.get("variables");
            } else if (map.get("variables") instanceof String && ((String)map.get("variables")).length() > 0) {
                try {
                    variables = (Map)this.deserializer.readValue((String)map.get("variables"), Map.class);
                }
                catch (IOException e) {
                    throw new BadRequestException("Variables must be a valid json object");
                }
            } else {
                variables = null;
            }
            String operationName = map.getOrDefault("operationName", null);
            futures.add(() -> this.index.getGraphQLExecutionResult((String)query.get("query"), this.serverContext, variables, operationName, maxResolves, TransmodelAPI.getTagsFromHeaders(headers)));
        }
        try {
            List<Future<ExecutionResult>> results = this.index.threadPool.invokeAll(futures);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)GraphQLResponseSerializer.serializeBatch(queries, results)).build();
        }
        catch (InterruptedException e) {
            LOG.error("Batch query interrupted", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Iterable<Tag> getTagsFromHeaders(HttpHeaders headers) {
        return tracingHeaderTags.stream().map(header -> {
            String value = headers.getHeaderString(header);
            return Tag.of((String)header, (String)(value == null ? "__UNKNOWN__" : value));
        }).collect(Collectors.toList());
    }
}

