/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater.azure;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusException;
import com.azure.messaging.servicebus.ServiceBusFailureReason;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationAsyncClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdaterParameters;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureSiriUpdater
implements GraphUpdater {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String configRef;
    private final String serviceBusUrl;
    private final SiriFuzzyTripMatcher fuzzyTripMatcher;
    private final EntityResolver entityResolver;
    private final Consumer<ServiceBusReceivedMessageContext> messageConsumer = this::messageConsumer;
    private final Consumer<ServiceBusErrorContext> errorConsumer = this::errorConsumer;
    private final String topicName;
    protected WriteToGraphCallback saveResultOnGraph;
    private ServiceBusProcessorClient eventProcessor;
    private ServiceBusAdministrationAsyncClient serviceBusAdmin;
    private boolean isPrimed = false;
    private String subscriptionName;
    protected String feedId;
    private final String dataInitializationUrl;
    protected int timeout;

    public AbstractAzureSiriUpdater(SiriAzureUpdaterParameters config, TransitModel transitModel) {
        this.configRef = config.configRef();
        this.serviceBusUrl = config.getServiceBusUrl();
        this.topicName = config.getTopicName();
        this.dataInitializationUrl = config.getDataInitializationUrl();
        this.timeout = config.getTimeout();
        this.feedId = config.feedId();
        DefaultTransitService transitService = new DefaultTransitService(transitModel);
        this.entityResolver = new EntityResolver(transitService, this.feedId);
        this.fuzzyTripMatcher = config.isFuzzyTripMatching() ? SiriFuzzyTripMatcher.of(transitService) : null;
    }

    protected abstract void messageConsumer(ServiceBusReceivedMessageContext var1);

    protected abstract void errorConsumer(ServiceBusErrorContext var1);

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void run() throws Exception {
        Objects.requireNonNull(this.topicName, "'topic' must be set");
        Objects.requireNonNull(this.serviceBusUrl, "'servicebus-url' must be set");
        Objects.requireNonNull(this.feedId, "'feedId' must be set");
        Preconditions.checkState((this.feedId.length() > 0 ? 1 : 0) != 0, (Object)"'feedId' must be set");
        this.subscriptionName = System.getenv("HOSTNAME");
        if (this.subscriptionName == null || this.subscriptionName.isBlank()) {
            this.subscriptionName = "otp-" + UUID.randomUUID();
        }
        this.serviceBusAdmin = new ServiceBusAdministrationClientBuilder().connectionString(this.serviceBusUrl).buildAsyncClient();
        CreateSubscriptionOptions options = new CreateSubscriptionOptions();
        options.setDefaultMessageTimeToLive(Duration.of(25L, ChronoUnit.HOURS));
        options.setAutoDeleteOnIdle(Duration.ofDays(1L));
        if (Boolean.TRUE.equals(this.serviceBusAdmin.getSubscriptionExists(this.topicName, this.subscriptionName).block())) {
            this.LOG.info("Subscription {} already exists", (Object)this.subscriptionName);
            this.serviceBusAdmin.deleteSubscription(this.topicName, this.subscriptionName).block();
            this.LOG.info("Service Bus deleted subscription {}.", (Object)this.subscriptionName);
        }
        this.serviceBusAdmin.createSubscription(this.topicName, this.subscriptionName, options).block();
        this.LOG.info("Service Bus created subscription {}", (Object)this.subscriptionName);
        this.initializeData();
        this.eventProcessor = new ServiceBusClientBuilder().connectionString(this.serviceBusUrl).processor().topicName(this.topicName).subscriptionName(this.subscriptionName).processError(this.errorConsumer).processMessage(this.messageConsumer).buildProcessorClient();
        this.eventProcessor.start();
        this.LOG.info("Service Bus processor started for topic {} and subscription {}", (Object)this.topicName, (Object)this.subscriptionName);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(this::teardown));
        }
        catch (IllegalStateException e) {
            this.LOG.error(e.getLocalizedMessage(), (Throwable)e);
            this.teardown();
        }
    }

    @Override
    public void teardown() {
        this.eventProcessor.stop();
        this.serviceBusAdmin.deleteSubscription(this.topicName, this.subscriptionName).block();
        this.LOG.info("Subscription {} deleted on topic {}", (Object)this.subscriptionName, (Object)this.topicName);
    }

    @Override
    public boolean isPrimed() {
        return this.isPrimed;
    }

    public void setPrimed(boolean primed) {
        this.isPrimed = primed;
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }

    SiriFuzzyTripMatcher fuzzyTripMatcher() {
        return this.fuzzyTripMatcher;
    }

    EntityResolver entityResolver() {
        return this.entityResolver;
    }

    private void initializeData() {
        int sleepPeriod = 1000;
        int attemptCounter = 1;
        while (true) {
            try {
                this.initializeData(this.dataInitializationUrl, this.messageConsumer);
            }
            catch (Exception e) {
                this.LOG.warn("Caught exception while initializing data will retry after {} ms - attempt {}. ({})", new Object[]{sleepPeriod *= 2, attemptCounter++, e.toString()});
                try {
                    Thread.sleep(sleepPeriod);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    protected abstract void initializeData(String var1, Consumer<ServiceBusReceivedMessageContext> var2) throws IOException, URISyntaxException;

    protected void defaultErrorConsumer(ServiceBusErrorContext errorContext) {
        this.LOG.error("Error when receiving messages from namespace={}, Entity={}", (Object)errorContext.getFullyQualifiedNamespace(), (Object)errorContext.getEntityPath());
        if (!(errorContext.getException() instanceof ServiceBusException)) {
            this.LOG.error("Non-ServiceBusException occurred!", errorContext.getException());
            return;
        }
        ServiceBusException e = (ServiceBusException)errorContext.getException();
        ServiceBusFailureReason reason = e.getReason();
        if (reason == ServiceBusFailureReason.MESSAGING_ENTITY_DISABLED || reason == ServiceBusFailureReason.MESSAGING_ENTITY_NOT_FOUND || reason == ServiceBusFailureReason.UNAUTHORIZED) {
            this.LOG.error("An unrecoverable error occurred. Stopping processing with reason {} {}", (Object)reason, (Object)e.getMessage());
        } else if (reason == ServiceBusFailureReason.MESSAGE_LOCK_LOST) {
            this.LOG.error("Message lock lost for message", (Throwable)e);
        } else if (reason == ServiceBusFailureReason.SERVICE_BUSY) {
            this.LOG.error("Service Bus is busy, wait and try again");
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e2) {
                this.LOG.error("Unable to sleep for period of time");
            }
        } else {
            this.LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

