/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.util.List;
import java.util.function.Consumer;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.ext.siri.updater.SiriETHttpTripUpdateSource;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.ResultLogger;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriETUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETUpdater.class);
    private final EstimatedTimetableSource updateSource;
    private final String feedId;
    protected WriteToGraphCallback saveResultOnGraph;
    private final SiriTimetableSnapshotSource snapshotSource;
    private final SiriFuzzyTripMatcher fuzzyTripMatcher;
    private final EntityResolver entityResolver;
    private final Consumer<UpdateResult> recordMetrics;

    public SiriETUpdater(SiriETUpdaterParameters config, TransitModel transitModel, SiriTimetableSnapshotSource timetableSnapshot) {
        super(config);
        this.feedId = config.feedId();
        this.updateSource = new SiriETHttpTripUpdateSource(config.sourceParameters());
        this.snapshotSource = timetableSnapshot;
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        DefaultTransitService transitService = new DefaultTransitService(transitModel);
        this.entityResolver = new EntityResolver(transitService, this.feedId);
        this.fuzzyTripMatcher = config.fuzzyTripMatching() ? SiriFuzzyTripMatcher.of(transitService) : null;
        LOG.info("Creating stop time updater (SIRI ET) running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.updateSource);
        this.recordMetrics = TripUpdateMetrics.streaming(config);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Siri updates;
            if ((updates = this.updateSource.getUpdates()) == null) continue;
            boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.getServiceDelivery();
            moreData = Boolean.TRUE.equals(serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List etds = serviceDelivery.getEstimatedTimetableDeliveries();
            if (etds == null) continue;
            this.saveResultOnGraph.execute((graph, transitModel) -> {
                UpdateResult result = this.snapshotSource.applyEstimatedTimetable(this.fuzzyTripMatcher, this.entityResolver, this.feedId, fullDataset, etds);
                ResultLogger.logUpdateResult(this.feedId, "siri-et", result);
                this.recordMetrics.accept(result);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Polling SIRI ET updater with update source = " + s;
    }
}

