/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.opentripplanner.ext.siri.AddedTripBuilder;
import org.opentripplanner.ext.siri.DebugString;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.ModifiedTripBuilder;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTripPatternCache;
import org.opentripplanner.ext.siri.SiriTripPatternIdGenerator;
import org.opentripplanner.ext.siri.TripAndPattern;
import org.opentripplanner.ext.siri.TripUpdate;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.model.UpdateSuccess;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDateBuilder;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.TimetableSnapshotSourceParameters;
import org.opentripplanner.updater.spi.UpdateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.EstimatedVersionFrameStructure;

public class SiriTimetableSnapshotSource
implements TimetableSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SiriTimetableSnapshotSource.class);
    private final TimetableSnapshot buffer = new TimetableSnapshot();
    private final ReentrantLock bufferLock = new ReentrantLock(true);
    private final SiriTripPatternIdGenerator tripPatternIdGenerator = new SiriTripPatternIdGenerator();
    private final SiriTripPatternCache tripPatternCache;
    private final TransitModel transitModel;
    private final TransitService transitService;
    private final TransitLayerUpdater transitLayerUpdater;
    private final Duration maxSnapshotFrequency;
    private volatile TimetableSnapshot snapshot = null;
    private final boolean purgeExpiredData;
    protected LocalDate lastPurgeDate = null;
    protected long lastSnapshotTime = -1L;

    public SiriTimetableSnapshotSource(TimetableSnapshotSourceParameters parameters, TransitModel transitModel) {
        this.transitModel = transitModel;
        this.transitService = new DefaultTransitService(transitModel);
        this.transitLayerUpdater = transitModel.getTransitLayerUpdater();
        this.maxSnapshotFrequency = parameters.maxSnapshotFrequency();
        this.purgeExpiredData = parameters.purgeExpiredData();
        this.tripPatternCache = new SiriTripPatternCache(this.tripPatternIdGenerator, this.transitService::getPatternForTrip);
        transitModel.initTimetableSnapshotProvider(this);
        this.getTimetableSnapshot(true);
    }

    @Override
    public TimetableSnapshot getTimetableSnapshot() {
        TimetableSnapshot snapshotToReturn;
        if (this.bufferLock.tryLock()) {
            try {
                snapshotToReturn = this.getTimetableSnapshot(false);
            }
            finally {
                this.bufferLock.unlock();
            }
        } else {
            snapshotToReturn = this.snapshot;
        }
        return snapshotToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult applyEstimatedTimetable(@Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver, String feedId, boolean fullDataset, List<EstimatedTimetableDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return UpdateResult.empty();
        }
        this.bufferLock.lock();
        ArrayList<Result<UpdateSuccess, UpdateError>> results = new ArrayList<Result<UpdateSuccess, UpdateError>>();
        try {
            if (fullDataset) {
                this.buffer.clear(feedId);
            }
            for (EstimatedTimetableDeliveryStructure etDelivery : updates) {
                for (EstimatedVersionFrameStructure estimatedJourneyVersion : etDelivery.getEstimatedJourneyVersionFrames()) {
                    List journeys = estimatedJourneyVersion.getEstimatedVehicleJourneies();
                    LOG.debug("Handling {} EstimatedVehicleJourneys.", (Object)journeys.size());
                    for (EstimatedVehicleJourney journey : journeys) {
                        results.add(this.apply(journey, this.transitModel, fuzzyTripMatcher, entityResolver));
                    }
                }
            }
            LOG.debug("message contains {} trip updates", (Object)updates.size());
            LOG.debug("end of update message");
            if (this.purgeExpiredData) {
                boolean modified = this.purgeExpiredData();
                this.getTimetableSnapshot(modified);
            } else {
                this.getTimetableSnapshot(false);
            }
        }
        finally {
            this.bufferLock.unlock();
        }
        return UpdateResult.ofResults(results);
    }

    private Result<UpdateSuccess, UpdateError> apply(EstimatedVehicleJourney journey, TransitModel transitModel, @Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver) {
        boolean shouldAddNewTrip = false;
        try {
            shouldAddNewTrip = this.shouldAddNewTrip(journey, entityResolver);
            Result<TripUpdate, UpdateError> result = shouldAddNewTrip ? new AddedTripBuilder(journey, transitModel, entityResolver, this.tripPatternIdGenerator::generateUniqueTripPatternId).build() : this.handleModifiedTrip(fuzzyTripMatcher, entityResolver, journey);
            if (result.isFailure()) {
                return result.toFailureResult();
            }
            return this.addTripToGraphAndBuffer(result.successValue(), journey, entityResolver);
        }
        catch (Throwable t) {
            LOG.warn("{} EstimatedJourney {} failed.", new Object[]{shouldAddNewTrip ? "Adding" : "Updating", DebugString.of(journey), t});
            return Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.UNKNOWN));
        }
    }

    private boolean shouldAddNewTrip(EstimatedVehicleJourney vehicleJourney, EntityResolver entityResolver) {
        if (!Boolean.TRUE.equals(vehicleJourney.isExtraJourney())) {
            return false;
        }
        return entityResolver.resolveTrip(vehicleJourney) == null;
    }

    private TimetableSnapshot getTimetableSnapshot(boolean force) {
        long now = System.currentTimeMillis();
        if (force || now - this.lastSnapshotTime > this.maxSnapshotFrequency.toMillis()) {
            if (force || this.buffer.isDirty()) {
                LOG.debug("Committing {}", (Object)this.buffer);
                this.snapshot = this.buffer.commit(this.transitLayerUpdater, force);
            } else {
                LOG.debug("Buffer was unchanged, keeping old snapshot.");
            }
            this.lastSnapshotTime = System.currentTimeMillis();
        } else {
            LOG.debug("Snapshot frequency exceeded. Reusing snapshot {}", (Object)this.snapshot);
        }
        return this.snapshot;
    }

    private Timetable getCurrentTimetable(TripPattern tripPattern, LocalDate serviceDate) {
        TimetableSnapshot timetableSnapshot = this.snapshot;
        if (timetableSnapshot != null) {
            return timetableSnapshot.resolve(tripPattern, serviceDate);
        }
        return tripPattern.getScheduledTimetable();
    }

    private Result<TripUpdate, UpdateError> handleModifiedTrip(@Nullable SiriFuzzyTripMatcher fuzzyTripMatcher, EntityResolver entityResolver, EstimatedVehicleJourney estimatedVehicleJourney) {
        TripPattern pattern;
        Trip trip = entityResolver.resolveTrip(estimatedVehicleJourney);
        if (!Boolean.TRUE.equals(estimatedVehicleJourney.isMonitored()) && !Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation())) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NOT_MONITORED);
        }
        LocalDate serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        if (serviceDate == null) {
            return UpdateError.result(trip != null ? trip.getId() : null, UpdateError.UpdateErrorType.NO_START_DATE);
        }
        if (trip != null) {
            pattern = this.transitService.getPatternForTrip(trip);
        } else if (fuzzyTripMatcher != null) {
            TripAndPattern tripAndPattern = fuzzyTripMatcher.match(estimatedVehicleJourney, entityResolver, this::getCurrentTimetable, this.buffer::getRealtimeAddedTripPattern);
            if (tripAndPattern == null) {
                LOG.debug("No trips found for EstimatedVehicleJourney. {}", (Object)DebugString.of(estimatedVehicleJourney));
                return UpdateError.result(null, UpdateError.UpdateErrorType.NO_FUZZY_TRIP_MATCH);
            }
            trip = tripAndPattern.trip();
            pattern = tripAndPattern.tripPattern();
        } else {
            return UpdateError.result(null, UpdateError.UpdateErrorType.NO_TRIP_ID);
        }
        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
        TripTimes existingTripTimes = currentTimetable.getTripTimes(trip);
        if (existingTripTimes == null) {
            LOG.debug("tripId {} not found in pattern.", (Object)trip.getId());
            return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN);
        }
        Result<TripUpdate, UpdateError> updateResult = new ModifiedTripBuilder(existingTripTimes, pattern, estimatedVehicleJourney, serviceDate, this.transitModel.getTimeZone(), entityResolver).build();
        if (updateResult.isFailure()) {
            LOG.info("Failed to update TripTimes for trip {}", (Object)trip);
            return updateResult.toFailureResult();
        }
        if (!updateResult.successValue().stopPattern().equals(pattern.getStopPattern())) {
            this.markScheduledTripAsDeleted(trip, serviceDate);
        }
        this.removePreviousRealtimeUpdate(trip, serviceDate);
        return updateResult;
    }

    private Result<UpdateSuccess, UpdateError> addTripToGraphAndBuffer(TripUpdate tripUpdate, EstimatedVehicleJourney estimatedVehicleJourney, EntityResolver entityResolver) {
        Trip trip = tripUpdate.tripTimes().getTrip();
        LocalDate serviceDate = tripUpdate.serviceDate();
        TripPattern pattern = this.tripPatternCache.getOrCreateTripPattern(tripUpdate.stopPattern(), trip, serviceDate);
        Result<UpdateSuccess, UpdateError> result = this.buffer.update(pattern, tripUpdate.tripTimes(), serviceDate);
        LOG.debug("Applied realtime data for trip {} on {}", (Object)trip, (Object)serviceDate);
        TripOnServiceDateBuilder tripOnServiceDateBuilder = entityResolver.createTripOnServiceDateBuilder(estimatedVehicleJourney);
        if (tripOnServiceDateBuilder != null) {
            this.buffer.addLastAddedTripOnServiceDate((TripOnServiceDate)tripOnServiceDateBuilder.withTrip(trip).withServiceDate(serviceDate).build());
        }
        return result;
    }

    private boolean markScheduledTripAsDeleted(Trip trip, LocalDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.transitService.getPatternForTrip(trip);
        if (pattern != null) {
            Timetable timetable = pattern.getScheduledTimetable();
            TripTimes tripTimes = timetable.getTripTimes(trip);
            if (tripTimes == null) {
                LOG.warn("Could not mark scheduled trip as deleted {}", (Object)trip.getId());
            } else {
                TripTimes newTripTimes = new TripTimes(tripTimes);
                newTripTimes.deleteTrip();
                this.buffer.update(pattern, newTripTimes, serviceDate);
                success = true;
            }
        }
        return success;
    }

    private boolean removePreviousRealtimeUpdate(Trip trip, LocalDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.buffer.getRealtimeAddedTripPattern(trip.getId(), serviceDate);
        if (pattern != null) {
            this.buffer.removeLastAddedTripPattern(trip.getId(), serviceDate);
            this.buffer.removeRealtimeUpdatedTripTimes(pattern, trip.getId(), serviceDate);
            success = true;
        }
        return success;
    }

    private boolean purgeExpiredData() {
        LocalDate today = LocalDate.now(this.transitModel.getTimeZone());
        LocalDate previously = today.minusDays(2L);
        if (this.lastPurgeDate != null && this.lastPurgeDate.compareTo(previously) > 0) {
            return false;
        }
        LOG.debug("purging expired realtime data");
        this.lastPurgeDate = previously;
        return this.buffer.purgeExpiredData(previously);
    }
}

