/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import org.opentripplanner.ext.siri.CallWrapper;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.TimetableHelper;
import org.opentripplanner.ext.siri.TripUpdate;
import org.opentripplanner.ext.siri.mapper.PickDropMapper;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.OccupancyEnumeration;

public class ModifiedTripBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableHelper.class);
    private final TripTimes existingTripTimes;
    private final TripPattern pattern;
    private final LocalDate serviceDate;
    private final ZoneId zoneId;
    private final EntityResolver entityResolver;
    private final List<CallWrapper> calls;
    private final boolean cancellation;
    private final OccupancyEnumeration occupancy;
    private final boolean predictionInaccurate;

    public ModifiedTripBuilder(TripTimes existingTripTimes, TripPattern pattern, EstimatedVehicleJourney journey, LocalDate serviceDate, ZoneId zoneId, EntityResolver entityResolver) {
        this.existingTripTimes = existingTripTimes;
        this.pattern = pattern;
        this.serviceDate = serviceDate;
        this.zoneId = zoneId;
        this.entityResolver = entityResolver;
        this.calls = CallWrapper.of(journey);
        this.cancellation = Boolean.TRUE.equals(journey.isCancellation());
        this.predictionInaccurate = Boolean.TRUE.equals(journey.isPredictionInaccurate());
        this.occupancy = journey.getOccupancy();
    }

    public ModifiedTripBuilder(TripTimes existingTripTimes, TripPattern pattern, LocalDate serviceDate, ZoneId zoneId, EntityResolver entityResolver, List<CallWrapper> calls, boolean cancellation, OccupancyEnumeration occupancy, boolean predictionInaccurate) {
        this.existingTripTimes = existingTripTimes;
        this.pattern = pattern;
        this.serviceDate = serviceDate;
        this.zoneId = zoneId;
        this.entityResolver = entityResolver;
        this.calls = calls;
        this.cancellation = cancellation;
        this.occupancy = occupancy;
        this.predictionInaccurate = predictionInaccurate;
    }

    public Result<TripUpdate, UpdateError> build() {
        TripTimes newTimes = new TripTimes(this.existingTripTimes);
        StopPattern stopPattern = ModifiedTripBuilder.createStopPattern(this.pattern, this.calls, this.entityResolver);
        if (this.cancellation || stopPattern.isAllStopsNonRoutable()) {
            LOG.debug("Trip is cancelled");
            newTimes.cancelTrip();
            return Result.success(new TripUpdate(this.pattern.getStopPattern(), newTimes, this.serviceDate));
        }
        this.applyUpdates(newTimes);
        if (this.pattern.getStopPattern().equals(stopPattern)) {
            newTimes.setRealTimeState(RealTimeState.UPDATED);
        } else {
            newTimes.setRealTimeState(RealTimeState.MODIFIED);
        }
        Result<?, UpdateError> result = newTimes.validateNonIncreasingTimes();
        if (result.isFailure()) {
            UpdateError updateError = result.failureValue();
            LOG.info("TripTimes are non-increasing after applying SIRI delay propagation - Trip {}. Stop index {}", (Object)updateError.tripId(), (Object)updateError.stopIndex());
            return Result.failure(updateError);
        }
        if (newTimes.getNumStops() != this.pattern.numberOfStops()) {
            return UpdateError.result(this.existingTripTimes.getTrip().getId(), UpdateError.UpdateErrorType.TOO_FEW_STOPS);
        }
        LOG.debug("A valid TripUpdate object was applied using the Timetable class update method.");
        return Result.success(new TripUpdate(stopPattern, newTimes, this.serviceDate));
    }

    private void applyUpdates(TripTimes newTimes) {
        ZonedDateTime startOfService = ServiceDateUtils.asStartOfService(this.serviceDate, this.zoneId);
        HashSet<CallWrapper> alreadyVisited = new HashSet<CallWrapper>();
        int departureFromPreviousStop = 0;
        int lastDepartureDelay = 0;
        List<StopLocation> stops = this.pattern.getStops();
        for (int callCounter = 0; callCounter < stops.size(); ++callCounter) {
            StopLocation stop = stops.get(callCounter);
            boolean foundMatch = false;
            for (CallWrapper call : this.calls) {
                RegularStop stopPoint;
                if (alreadyVisited.contains(call) || !(foundMatch = stop.equals(stopPoint = this.entityResolver.resolveQuay(call.getStopPointRef())) || stop.isPartOfSameStationAs(stopPoint))) continue;
                TimetableHelper.applyUpdates(startOfService, newTimes, callCounter, callCounter == stops.size() - 1, this.predictionInaccurate, call, this.occupancy);
                alreadyVisited.add(call);
                lastDepartureDelay = newTimes.getDepartureDelay(callCounter);
                break;
            }
            if (!foundMatch) {
                if (this.pattern.isBoardAndAlightAt(callCounter, PickDrop.NONE)) {
                    newTimes.updateArrivalTime(callCounter, departureFromPreviousStop);
                    newTimes.updateDepartureTime(callCounter, departureFromPreviousStop);
                } else {
                    int arrivalDelay = lastDepartureDelay;
                    int departureDelay = lastDepartureDelay;
                    if (lastDepartureDelay == 0) {
                        arrivalDelay = this.existingTripTimes.getArrivalDelay(callCounter);
                        departureDelay = this.existingTripTimes.getDepartureDelay(callCounter);
                    }
                    newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                    newTimes.updateDepartureDelay(callCounter, departureDelay);
                }
            }
            departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
        }
    }

    static StopPattern createStopPattern(TripPattern pattern, List<CallWrapper> calls, EntityResolver entityResolver) {
        int numberOfStops = pattern.numberOfStops();
        StopPattern.StopPatternBuilder builder = pattern.getStopPattern().mutate();
        HashSet<CallWrapper> alreadyVisited = new HashSet<CallWrapper>();
        block0: for (int i = 0; i < numberOfStops; ++i) {
            StopLocation stop;
            builder.stops[i] = stop = pattern.getStop(i);
            builder.dropoffs[i] = pattern.getAlightType(i);
            builder.pickups[i] = pattern.getBoardType(i);
            for (CallWrapper call : calls) {
                RegularStop callStop;
                if (alreadyVisited.contains(call) || !stop.equals(callStop = entityResolver.resolveQuay(call.getStopPointRef())) && !stop.isPartOfSameStationAs(callStop)) continue;
                int stopIndex = i;
                builder.stops[stopIndex] = callStop;
                PickDropMapper.mapPickUpType(call, builder.pickups[stopIndex]).ifPresent(value -> {
                    builder.pickups[stopIndex] = value;
                });
                PickDropMapper.mapDropOffType(call, builder.dropoffs[stopIndex]).ifPresent(value -> {
                    builder.dropoffs[stopIndex] = value;
                });
                alreadyVisited.add(call);
                continue block0;
            }
        }
        return builder.build();
    }
}

