/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing.service.uber;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.ridehailing.CachingRideHailingService;
import org.opentripplanner.ext.ridehailing.RideHailingServiceParameters;
import org.opentripplanner.ext.ridehailing.model.ArrivalTime;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.ext.ridehailing.model.RideEstimateRequest;
import org.opentripplanner.ext.ridehailing.model.RideHailingProvider;
import org.opentripplanner.ext.ridehailing.service.oauth.OAuthService;
import org.opentripplanner.ext.ridehailing.service.oauth.UrlEncodedOAuthService;
import org.opentripplanner.ext.ridehailing.service.uber.UberArrivalEstimateResponse;
import org.opentripplanner.ext.ridehailing.service.uber.UberTripTimeEstimateResponse;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.transit.model.basic.Money;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberService
extends CachingRideHailingService {
    private static final Logger LOG = LoggerFactory.getLogger(UberService.class);
    private static final String DEFAULT_BASE_URL = "https://api.uber.com/v1.2/";
    private static final String DEFAULT_TIME_ESTIMATE_URI = "https://api.uber.com/v1.2/estimates/time";
    private static final String DEFAULT_PRICE_ESTIMATE_URI = "https://api.uber.com/v1.2/estimates/price";
    private static final ObjectMapper MAPPER = ObjectMappers.ignoringExtraFields();
    private final OAuthService oauthService;
    private final String timeEstimateUri;
    private final String priceEstimateUri;

    public UberService(RideHailingServiceParameters config) {
        this(new UrlEncodedOAuthService(config.clientSecret(), config.clientId(), "ride_request.estimate", UriBuilder.fromUri((String)"https://login.uber.com/oauth/v2/token").build(new Object[0])), DEFAULT_PRICE_ESTIMATE_URI, DEFAULT_TIME_ESTIMATE_URI);
    }

    UberService(OAuthService oauthService, String priceEstimateUri, String timeEstimateUri) {
        this.oauthService = oauthService;
        this.priceEstimateUri = priceEstimateUri;
        this.timeEstimateUri = timeEstimateUri;
    }

    @Override
    public RideHailingProvider provider() {
        return RideHailingProvider.UBER;
    }

    @Override
    public List<ArrivalTime> queryArrivalTimes(WgsCoordinate coord) throws IOException {
        URI uri;
        URI finalUri = uri = UriBuilder.fromUri((String)this.timeEstimateUri).build(new Object[0]);
        if (uri.getScheme().equalsIgnoreCase("https")) {
            finalUri = UriBuilder.fromUri((URI)uri).queryParam("start_latitude", new Object[]{coord.latitude()}).queryParam("start_longitude", new Object[]{coord.longitude()}).build(new Object[0]);
        }
        LOG.info("Made arrival time request to Uber API at following URL: {}", (Object)uri);
        InputStream responseStream = HttpUtils.openInputStream(finalUri, this.headers());
        UberArrivalEstimateResponse response = (UberArrivalEstimateResponse)MAPPER.readValue(responseStream, UberArrivalEstimateResponse.class);
        LOG.debug("Received {} Uber arrival time estimates", (Object)response.times().size());
        List<ArrivalTime> arrivalTimes = response.times().stream().map(time -> new ArrivalTime(RideHailingProvider.UBER, time.product_id(), time.localized_display_name(), Duration.ofSeconds(time.estimate()), this.productIsWheelchairAccessible(time.product_id()))).toList();
        if (arrivalTimes.isEmpty()) {
            LOG.warn("No Uber service available at {}", (Object)coord);
        }
        return arrivalTimes;
    }

    @Override
    public List<RideEstimate> queryRideEstimates(RideEstimateRequest request) throws IOException {
        URI uri;
        URI finalUri = uri = UriBuilder.fromUri((String)this.priceEstimateUri).build(new Object[0]);
        if (uri.getScheme().equalsIgnoreCase("https")) {
            finalUri = UriBuilder.fromUri((URI)uri).queryParam("start_latitude", new Object[]{request.startPosition().latitude()}).queryParam("start_longitude", new Object[]{request.startPosition().longitude()}).queryParam("end_latitude", new Object[]{request.endPosition().latitude()}).queryParam("end_longitude", new Object[]{request.endPosition().longitude()}).build(new Object[0]);
        }
        LOG.info("Made price estimate request to Uber API at following URL: {}", (Object)uri);
        InputStream responseStream = HttpUtils.openInputStream(finalUri, this.headers());
        UberTripTimeEstimateResponse response = (UberTripTimeEstimateResponse)MAPPER.readValue(responseStream, UberTripTimeEstimateResponse.class);
        if (response.prices() == null) {
            throw new IOException("Unexpected response format");
        }
        LOG.debug("Received {} Uber price estimates", (Object)response.prices().size());
        return response.prices().stream().map(price -> {
            Currency currency = Currency.getInstance(price.currency_code());
            return new RideEstimate(RideHailingProvider.UBER, Duration.ofSeconds(price.duration()), new Money(currency, price.low_estimate() * 100), new Money(currency, price.high_estimate() * 100), price.product_id(), price.display_name(), this.productIsWheelchairAccessible(price.product_id()));
        }).toList();
    }

    @Nonnull
    private Map<String, String> headers() throws IOException {
        return Map.ofEntries(Map.entry("Authorization", "Bearer %s".formatted(this.oauthService.getToken())), Map.entry("Accept-Language", "en_US"), Map.entry("Content-Type", "application/json"));
    }
}

