/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.reportapi.model.CsvReportBuilder;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;

public class TransfersReport {
    private static final boolean BOARD = true;
    private static final boolean ALIGHT = false;
    private static final int NOT_SET = -1;
    private final List<ConstrainedTransfer> transfers;
    private final TransitService transitService;
    private final CsvReportBuilder buf = new CsvReportBuilder();

    private TransfersReport(List<ConstrainedTransfer> transfers, TransitService transitService) {
        this.transfers = transfers;
        this.transitService = transitService;
    }

    public static String export(List<ConstrainedTransfer> transfers, TransitService transitService) {
        return new TransfersReport(transfers, transitService).export();
    }

    String export() {
        this.buf.addHeader("Id", "Operator", "From", "FromId", "FromRoute", "FromTrip", "FromStop", "FromSpecificity", "To", "ToId", "ToRoute", "ToTrip", "ToStop", "ToSpecificity", "ArrivalTime", "DepartureTime", "TransferTime", "Walk", "Priority", "MaxWaitTime", "StaySeated", "Guaranteed");
        this.transfers.forEach(t -> {
            TxPoint from = this.pointInfo(t.getFrom(), false);
            TxPoint to = this.pointInfo(t.getTo(), true);
            String dist = from.coordinate == null || to.coordinate == null ? "" : String.format("%.0fm", SphericalDistanceLibrary.fastDistance(from.coordinate.asJtsCoordinate(), to.coordinate.asJtsCoordinate()));
            String duration = from.time == -1 || to.time == -1 ? "" : DurationUtils.durationToStr(to.time - from.time);
            TransferConstraint c = t.getTransferConstraint();
            this.buf.addText(t.getId() == null ? "" : t.getId().getId());
            this.buf.addText((from.operator.isEmpty() ? to : from).operator);
            this.buf.addText(from.type);
            this.buf.addText(from.entityId);
            this.buf.addText(from.route);
            this.buf.addText(from.trip);
            this.buf.addText(from.location());
            this.buf.addNumber(from.specificity);
            this.buf.addText(to.type);
            this.buf.addText(to.entityId);
            this.buf.addText(to.route);
            this.buf.addText(to.trip);
            this.buf.addText(to.location());
            this.buf.addNumber(to.specificity);
            this.buf.addTime(from.time, -1);
            this.buf.addTime(to.time, -1);
            this.buf.addText(duration);
            this.buf.addText(dist);
            this.buf.addEnum(c.getPriority());
            this.buf.addDuration(c.getMaxWaitTime(), -1);
            this.buf.addOptText(c.isStaySeated(), "YES");
            this.buf.addOptText(c.isGuaranteed(), "YES");
            this.buf.newLine();
        });
        return this.buf.toString();
    }

    private static void addLocation(TxPoint r, TripPattern pattern, StopLocation stop, Trip trip, boolean boarding) {
        if (pattern == null) {
            r.loc = r.loc + stop.getName() + " [Pattern no found]";
            return;
        }
        int stopPosition = pattern.findStopPosition(stop);
        r.coordinate = stop.getCoordinate();
        if (stopPosition < 0) {
            r.loc = r.loc + "[Stop not found in pattern: " + stop.getName() + "]";
            return;
        }
        r.loc = r.loc + stop.getName() + " [" + stopPosition + "]";
        if (trip != null) {
            TripTimes tt = pattern.getScheduledTimetable().getTripTimes(trip);
            r.time = boarding ? tt.getScheduledDepartureTime(stopPosition) : tt.getScheduledArrivalTime(stopPosition);
        }
    }

    private TxPoint pointInfo(TransferPoint p, boolean boarding) {
        TxPoint r = new TxPoint();
        if (p instanceof TripTransferPoint) {
            TripTransferPoint tp = (TripTransferPoint)p;
            Trip trip = tp.getTrip();
            Route route = trip.getRoute();
            TripPattern ptn = this.transitService.getPatternForTrip(trip);
            r.operator = TransfersReport.getName(trip.getOperator());
            r.type = "Trip";
            r.entityId = trip.getId().getId();
            r.route = route.getName() + " " + route.getMode() + " " + route.getLongName();
            r.trip = trip.getHeadsign() != null ? trip.getHeadsign().toString() : null;
            StopLocation stop = ptn.getStop(tp.getStopPositionInPattern());
            TransfersReport.addLocation(r, ptn, stop, trip, boarding);
        } else if (p instanceof RouteStopTransferPoint) {
            RouteStopTransferPoint rp = (RouteStopTransferPoint)p;
            Route route = rp.getRoute();
            TripPattern ptn = this.transitService.getPatternsForRoute(route).stream().findFirst().orElse(null);
            r.operator = TransfersReport.getName(route.getOperator());
            r.type = "Route";
            r.entityId = route.getId().getId();
            r.route = route.getName() + " " + route.getMode() + " " + route.getLongName();
            TransfersReport.addLocation(r, ptn, rp.getStop(), null, boarding);
        } else if (p instanceof RouteStationTransferPoint) {
            RouteStationTransferPoint rp = (RouteStationTransferPoint)p;
            Route route = rp.getRoute();
            r.operator = TransfersReport.getName(route.getOperator());
            r.type = "Route";
            r.entityId = route.getId().getId();
            r.route = route.getName() + " " + route.getMode() + " " + route.getLongName();
            r.loc = r.loc + rp.getStation().getName();
            r.coordinate = rp.getStation().getCoordinate();
        } else if (p instanceof StopTransferPoint) {
            StopTransferPoint sp = (StopTransferPoint)p;
            StopLocation stop = sp.getStop();
            r.type = "Stop";
            r.entityId = stop.getId().getId();
            r.loc = Optional.ofNullable(stop.getName()).map(I18NString::toString).orElse("");
            r.coordinate = stop.getCoordinate();
        } else if (p instanceof StationTransferPoint) {
            StationTransferPoint sp = (StationTransferPoint)p;
            Station station = sp.getStation();
            r.type = "Station";
            r.entityId = station.getId().getId();
            r.loc = station.getName().toString();
            r.coordinate = station.getCoordinate();
        }
        r.specificity = p.getSpecificityRanking();
        r.coordinate = null;
        return r;
    }

    @Nonnull
    private static String getName(Operator operator) {
        return Optional.ofNullable(operator).map(o -> o.getId().getId()).orElse("");
    }

    static class TxPoint {
        private String operator = "";
        private String type = "";
        private String entityId = "";
        private String loc = "";
        private String trip = "";
        private String route = "";
        private Integer specificity = null;
        private WgsCoordinate coordinate = null;
        private int time = -1;

        TxPoint() {
        }

        String location() {
            return this.coordinate == null ? this.loc : this.loc + " " + this.coordinate;
        }
    }
}

