/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.realtimeresolver;

import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.transit.service.TransitService;

public class RealtimeResolver {
    public static void populateLegsWithRealtime(List<Itinerary> itineraries, TransitService transitService) {
        itineraries.forEach(it -> {
            if (it.isFlaggedForDeletion()) {
                return;
            }
            List<Leg> legs = it.getLegs().stream().map(leg -> {
                LegReference ref = leg.getLegReference();
                if (ref == null) {
                    return leg;
                }
                if (!leg.isScheduledTransitLeg()) {
                    return leg;
                }
                Leg realtimeLeg = ref.getLeg(transitService);
                if (realtimeLeg != null) {
                    return RealtimeResolver.combineReferenceWithOriginal(realtimeLeg.asScheduledTransitLeg(), leg.asScheduledTransitLeg());
                }
                return leg;
            }).collect(Collectors.toList());
            it.setLegs(legs);
        });
    }

    private static Leg combineReferenceWithOriginal(ScheduledTransitLeg reference, ScheduledTransitLeg original) {
        ScheduledTransitLeg leg = new ScheduledTransitLeg(reference.getTripTimes(), reference.getTripPattern(), reference.getBoardStopPosInPattern(), reference.getAlightStopPosInPattern(), reference.getStartTime(), reference.getEndTime(), reference.getServiceDate(), reference.getZoneId(), original.getTransferFromPrevLeg(), original.getTransferToNextLeg(), original.getGeneralizedCost(), original.accessibilityScore());
        reference.getTransitAlerts().forEach(leg::addAlert);
        return leg;
    }
}

