/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.service.vehiclepositions.model.RealtimeVehiclePosition;
import org.opentripplanner.transit.model.timetable.Trip;

public class LegacyGraphQLVehiclePositionImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLVehiclePosition {
    @Override
    public DataFetcher<Double> heading() {
        return env -> this.getSource(env).heading();
    }

    @Override
    public DataFetcher<String> label() {
        return env -> this.getSource(env).label();
    }

    @Override
    public DataFetcher<Long> lastUpdated() {
        return env -> this.getSource(env).time().getEpochSecond();
    }

    @Override
    public DataFetcher<Double> lat() {
        return env -> this.getSource(env).coordinates().latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return env -> this.getSource(env).coordinates().longitude();
    }

    @Override
    public DataFetcher<Double> speed() {
        return env -> this.getSource(env).speed();
    }

    @Override
    public DataFetcher<RealtimeVehiclePosition.StopRelationship> stopRelationship() {
        return env -> this.getSource(env).stop();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return env -> this.getSource(env).trip();
    }

    @Override
    public DataFetcher<String> vehicleId() {
        return env -> this.getSource(env).vehicleId().toString();
    }

    private RealtimeVehiclePosition getSource(DataFetchingEnvironment environment) {
        return (RealtimeVehiclePosition)environment.getSource();
    }
}

