/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingState;

public class LegacyGraphQLVehicleParkingImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLVehicleParking {
    @Override
    public DataFetcher<Boolean> anyCarPlaces() {
        return environment -> this.getSource(environment).hasAnyCarPlaces();
    }

    @Override
    public DataFetcher<VehicleParkingSpaces> availability() {
        return environment -> this.getSource(environment).getAvailability();
    }

    @Override
    public DataFetcher<Boolean> bicyclePlaces() {
        return environment -> this.getSource(environment).hasBicyclePlaces();
    }

    @Override
    public DataFetcher<VehicleParkingSpaces> capacity() {
        return environment -> this.getSource(environment).getCapacity();
    }

    @Override
    public DataFetcher<Boolean> carPlaces() {
        return environment -> this.getSource(environment).hasCarPlaces();
    }

    @Override
    public DataFetcher<String> detailsUrl() {
        return environment -> this.getSource(environment).getDetailsUrl();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("VehicleParking", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> imageUrl() {
        return environment -> this.getSource(environment).getImageUrl();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getCoordinate().latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getCoordinate().longitude();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).getName(), environment);
    }

    @Override
    public DataFetcher<String> note() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).getNote(), environment);
    }

    @Override
    public DataFetcher<OHCalendar> openingHours() {
        return environment -> this.getSource(environment).getOpeningHours();
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).hasRealTimeData();
    }

    @Override
    public DataFetcher<VehicleParkingState> state() {
        return environment -> this.getSource(environment).getState();
    }

    @Override
    public DataFetcher<Iterable<String>> tags() {
        return environment -> this.getSource(environment).getTags();
    }

    @Override
    public DataFetcher<String> vehicleParkingId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Boolean> wheelchairAccessibleCarPlaces() {
        return environment -> this.getSource(environment).hasWheelchairAccessibleCarPlaces();
    }

    private VehicleParking getSource(DataFetchingEnvironment environment) {
        return (VehicleParking)environment.getSource();
    }
}

