/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.support.SemanticHash;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;

public class LegacyGraphQLTripImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLTrip {
    @Override
    public DataFetcher<Iterable<String>> activeDates() {
        return environment -> this.getTransitService(environment).getCalendarService().getServiceDatesForServiceId(this.getSource(environment).getServiceId()).stream().map(ServiceDateUtils::asCompactString).collect(Collectors.toList());
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            LegacyGraphQLTypes.LegacyGraphQLTripAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLTripAlertsArgs(environment.getArguments());
            List<LegacyGraphQLTypes.LegacyGraphQLTripAlertType> types = args.getLegacyGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case TRIP: {
                            alerts.addAll(alertService.getTripAlerts(this.getSource(environment).getId(), null));
                            break;
                        }
                        case AGENCY: {
                            alerts.addAll(alertService.getAgencyAlerts(this.getAgency(environment).getId()));
                            break;
                        }
                        case ROUTE_TYPE: {
                            int routeType = this.getRoute(environment).getGtfsType();
                            alerts.addAll(alertService.getRouteTypeAlerts(routeType, this.getSource(environment).getId().getFeedId()));
                            alerts.addAll(alertService.getRouteTypeAndAgencyAlerts(routeType, this.getAgency(environment).getId()));
                            break;
                        }
                        case ROUTE: {
                            alerts.addAll(alertService.getRouteAlerts(this.getRoute(environment).getId()));
                            break;
                        }
                        case PATTERN: {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(this.getSource(environment).getDirection(), this.getRoute(environment).getId()));
                            break;
                        }
                        case STOPS_ON_TRIP: {
                            alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.entities().stream().anyMatch(entity -> {
                                EntitySelector.StopAndTrip stopAndTrip;
                                EntitySelector.StopAndRoute stopAndRoute;
                                return entity instanceof EntitySelector.StopAndRoute && (stopAndRoute = (EntitySelector.StopAndRoute)entity).routeId().equals(this.getRoute(environment).getId()) || entity instanceof EntitySelector.StopAndTrip && (stopAndTrip = (EntitySelector.StopAndTrip)entity).tripId().equals(this.getSource(environment).getId());
                            })).toList());
                            this.getStops(environment).forEach(stop -> {
                                FeedScopedId stopId = ((StopLocation)stop).getId();
                                alerts.addAll(alertService.getStopAlerts(stopId));
                            });
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getTripAlerts(this.getSource(environment).getId(), null);
        };
    }

    @Override
    public DataFetcher<TripTimeOnDate> arrivalStoptime() {
        return environment -> {
            try {
                TransitService transitService = this.getTransitService(environment);
                TripPattern tripPattern = this.getTripPattern(environment);
                if (tripPattern == null) {
                    return null;
                }
                Timetable timetable = tripPattern.getScheduledTimetable();
                TripTimes triptimes = timetable.getTripTimes(this.getSource(environment));
                LocalDate serviceDate = null;
                Instant midnight = null;
                LegacyGraphQLTypes.LegacyGraphQLTripArrivalStoptimeArgs args = new LegacyGraphQLTypes.LegacyGraphQLTripArrivalStoptimeArgs(environment.getArguments());
                if (args.getLegacyGraphQLServiceDate() != null) {
                    serviceDate = ServiceDateUtils.parseString(args.getLegacyGraphQLServiceDate());
                    midnight = ServiceDateUtils.asStartOfService(serviceDate, transitService.getTimeZone()).toInstant();
                }
                return new TripTimeOnDate(triptimes, triptimes.getNumStops() - 1, tripPattern, serviceDate, midnight);
            }
            catch (ParseException e) {
                return null;
            }
        };
    }

    @Override
    public DataFetcher<String> bikesAllowed() {
        return environment -> switch (this.getSource(environment).getBikesAllowed()) {
            default -> throw new IncompatibleClassChangeError();
            case BikeAccess.UNKNOWN -> "NO_INFORMATION";
            case BikeAccess.ALLOWED -> "POSSIBLE";
            case BikeAccess.NOT_ALLOWED -> "NOT_POSSIBLE";
        };
    }

    @Override
    public DataFetcher<String> blockId() {
        return environment -> this.getSource(environment).getGtfsBlockId();
    }

    @Override
    public DataFetcher<TripTimeOnDate> departureStoptime() {
        return environment -> {
            try {
                TransitService transitService = this.getTransitService(environment);
                TripPattern tripPattern = this.getTripPattern(environment);
                if (tripPattern == null) {
                    return null;
                }
                Timetable timetable = tripPattern.getScheduledTimetable();
                TripTimes triptimes = timetable.getTripTimes(this.getSource(environment));
                LocalDate serviceDate = null;
                Instant midnight = null;
                LegacyGraphQLTypes.LegacyGraphQLTripDepartureStoptimeArgs args = new LegacyGraphQLTypes.LegacyGraphQLTripDepartureStoptimeArgs(environment.getArguments());
                if (args.getLegacyGraphQLServiceDate() != null) {
                    serviceDate = ServiceDateUtils.parseString(args.getLegacyGraphQLServiceDate());
                    midnight = ServiceDateUtils.asStartOfService(serviceDate, transitService.getTimeZone()).toInstant();
                }
                return new TripTimeOnDate(triptimes, 0, tripPattern, serviceDate, midnight);
            }
            catch (ParseException e) {
                return null;
            }
        };
    }

    @Override
    public DataFetcher<String> directionId() {
        return environment -> {
            Direction direction = this.getSource(environment).getDirection();
            if (direction == Direction.UNKNOWN) {
                return null;
            }
            return Integer.toString(direction.gtfsCode);
        };
    }

    @Override
    public DataFetcher<Iterable<Iterable<Double>>> geometry() {
        return environment -> {
            TripPattern tripPattern = this.getTripPattern(environment);
            if (tripPattern == null) {
                return null;
            }
            LineString geometry = tripPattern.getGeometry();
            if (geometry == null) {
                return null;
            }
            return Arrays.stream(geometry.getCoordinateSequence().toCoordinateArray()).map(coordinate -> Arrays.asList(coordinate.x, coordinate.y)).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Trip", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<TripPattern> pattern() {
        return this::getTripPattern;
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getSource(environment).getRoute();
    }

    @Override
    public DataFetcher<String> routeShortName() {
        return environment -> {
            Trip trip = this.getSource(environment);
            return trip.getRoute().getShortName();
        };
    }

    @Override
    public DataFetcher<String> semanticHash() {
        return environment -> {
            TripPattern tripPattern = this.getTripPattern(environment);
            if (tripPattern == null) {
                return null;
            }
            return SemanticHash.forTripPattern(tripPattern, this.getSource(environment));
        };
    }

    @Override
    public DataFetcher<String> serviceId() {
        return environment -> this.getSource(environment).getServiceId().toString();
    }

    @Override
    public DataFetcher<String> shapeId() {
        return environment -> Optional.ofNullable(this.getSource(environment).getShapeId()).map(FeedScopedId::toString).orElse(null);
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return this::getStops;
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimes() {
        return environment -> {
            TripPattern tripPattern = this.getTripPattern(environment);
            if (tripPattern == null) {
                return List.of();
            }
            return TripTimeOnDate.fromTripTimes(tripPattern.getScheduledTimetable(), this.getSource(environment));
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesForDate() {
        return environment -> {
            try {
                TransitService transitService = this.getTransitService(environment);
                Trip trip = this.getSource(environment);
                LegacyGraphQLTypes.LegacyGraphQLTripStoptimesForDateArgs args = new LegacyGraphQLTypes.LegacyGraphQLTripStoptimesForDateArgs(environment.getArguments());
                ZoneId timeZone = transitService.getTimeZone();
                LocalDate serviceDate = args.getLegacyGraphQLServiceDate() != null ? ServiceDateUtils.parseString(args.getLegacyGraphQLServiceDate()) : LocalDate.now(timeZone);
                TripPattern tripPattern = transitService.getPatternForTrip(trip, serviceDate);
                if (tripPattern == null) {
                    return List.of();
                }
                Instant midnight = ServiceDateUtils.asStartOfService(serviceDate, timeZone).toInstant();
                Timetable timetable = transitService.getTimetableForTripPattern(tripPattern, serviceDate);
                return TripTimeOnDate.fromTripTimes(timetable, trip, serviceDate, midnight);
            }
            catch (ParseException e) {
                return null;
            }
        };
    }

    @Override
    public DataFetcher<Geometry> tripGeometry() {
        return environment -> {
            TripPattern tripPattern = this.getTripPattern(environment);
            if (tripPattern == null) {
                return null;
            }
            return tripPattern.getGeometry();
        };
    }

    @Override
    public DataFetcher<String> tripHeadsign() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).getHeadsign(), environment);
    }

    @Override
    public DataFetcher<String> tripShortName() {
        return environment -> this.getSource(environment).getShortName();
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLWheelchairBoarding> wheelchairAccessible() {
        return environment -> LegacyGraphQLUtils.toGraphQL(this.getSource(environment).getWheelchairBoarding());
    }

    private List<Object> getStops(DataFetchingEnvironment environment) {
        TripPattern tripPattern = this.getTripPattern(environment);
        if (tripPattern == null) {
            return List.of();
        }
        return List.copyOf(tripPattern.getStops());
    }

    private Agency getAgency(DataFetchingEnvironment environment) {
        return this.getRoute(environment).getAgency();
    }

    private Route getRoute(DataFetchingEnvironment environment) {
        return this.getSource(environment).getRoute();
    }

    private TripPattern getTripPattern(DataFetchingEnvironment environment) {
        return this.getTransitService(environment).getPatternForTrip((Trip)environment.getSource());
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).transitService();
    }

    private Trip getSource(DataFetchingEnvironment environment) {
        return (Trip)environment.getSource();
    }
}

