/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.LocalDateMapper;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.ext.ridehailing.model.RideHailingLeg;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.alternativelegs.AlternativeLegs;
import org.opentripplanner.routing.alternativelegs.AlternativeLegsFilter;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.timetable.Trip;

public class LegacyGraphQLLegImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLLeg {
    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> this.getSource(environment).getTransitAlerts();
    }

    @Override
    public DataFetcher<Integer> arrivalDelay() {
        return environment -> this.getSource(environment).getArrivalDelay();
    }

    @Override
    public DataFetcher<Integer> departureDelay() {
        return environment -> this.getSource(environment).getDepartureDelay();
    }

    @Override
    public DataFetcher<Double> distance() {
        return environment -> this.getSource(environment).getDistanceMeters();
    }

    @Override
    public DataFetcher<BookingInfo> dropOffBookingInfo() {
        return environment -> this.getSource(environment).getDropOffBookingInfo();
    }

    @Override
    public DataFetcher<String> dropoffType() {
        return environment -> {
            if (this.getSource(environment).getAlightRule() == null) {
                return PickDrop.SCHEDULED.name();
            }
            return this.getSource(environment).getAlightRule().name();
        };
    }

    @Override
    public DataFetcher<Double> duration() {
        return environment -> this.getSource(environment).getDuration().toSeconds();
    }

    @Override
    public DataFetcher<Long> endTime() {
        return environment -> this.getSource(environment).getEndTime().toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<StopArrival> from() {
        return environment -> {
            Leg source = this.getSource(environment);
            return new StopArrival(source.getFrom(), source.getStartTime(), source.getStartTime(), source.getBoardStopPosInPattern(), source.getBoardingGtfsStopSequence());
        };
    }

    @Override
    public DataFetcher<Integer> generalizedCost() {
        return environment -> this.getSource(environment).getGeneralizedCost();
    }

    @Override
    public DataFetcher<Boolean> interlineWithPreviousLeg() {
        return environment -> this.getSource(environment).isInterlinedWithPreviousLeg();
    }

    @Override
    public DataFetcher<Boolean> intermediatePlace() {
        return environment -> false;
    }

    @Override
    public DataFetcher<Iterable<StopArrival>> intermediatePlaces() {
        return environment -> this.getSource(environment).getIntermediateStops();
    }

    @Override
    public DataFetcher<Iterable<Object>> intermediateStops() {
        return environment -> {
            List<StopArrival> intermediateStops = this.getSource(environment).getIntermediateStops();
            if (intermediateStops == null) {
                return null;
            }
            return intermediateStops.stream().map(intermediateStop -> intermediateStop.place.stop).filter(Objects::nonNull).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Geometry> legGeometry() {
        return environment -> this.getSource(environment).getLegGeometry();
    }

    @Override
    public DataFetcher<String> mode() {
        return environment -> {
            Leg leg = this.getSource(environment);
            if (leg instanceof StreetLeg) {
                StreetLeg s = (StreetLeg)leg;
                return s.getMode().name();
            }
            if (leg instanceof TransitLeg) {
                TransitLeg s = (TransitLeg)leg;
                return s.getMode().name();
            }
            throw new IllegalStateException("Unhandled leg type: " + leg);
        };
    }

    @Override
    public DataFetcher<BookingInfo> pickupBookingInfo() {
        return environment -> this.getSource(environment).getPickupBookingInfo();
    }

    @Override
    public DataFetcher<String> pickupType() {
        return environment -> {
            if (this.getSource(environment).getBoardRule() == null) {
                return PickDrop.SCHEDULED.name();
            }
            return this.getSource(environment).getBoardRule().name();
        };
    }

    @Override
    public DataFetcher<Boolean> realTime() {
        return environment -> this.getSource(environment).getRealTime();
    }

    @Override
    public DataFetcher<String> realtimeState() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Boolean> rentedBike() {
        return environment -> this.getSource(environment).getRentedVehicle();
    }

    @Override
    public DataFetcher<RideEstimate> rideHailingEstimate() {
        return environment -> {
            Leg leg = this.getSource(environment);
            if (leg instanceof RideHailingLeg) {
                RideHailingLeg rhl = (RideHailingLeg)leg;
                return rhl.rideEstimate();
            }
            return null;
        };
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getSource(environment).getRoute();
    }

    @Override
    public DataFetcher<String> serviceDate() {
        return environment -> LocalDateMapper.mapToApi(this.getSource(environment).getServiceDate());
    }

    @Override
    public DataFetcher<Long> startTime() {
        return environment -> this.getSource(environment).getStartTime().toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<Iterable<WalkStep>> steps() {
        return environment -> this.getSource(environment).getWalkSteps();
    }

    @Override
    public DataFetcher<StopArrival> to() {
        return environment -> {
            Leg source = this.getSource(environment);
            return new StopArrival(source.getTo(), source.getEndTime(), source.getEndTime(), source.getAlightStopPosInPattern(), source.getAlightGtfsStopSequence());
        };
    }

    @Override
    public DataFetcher<Boolean> transitLeg() {
        return environment -> this.getSource(environment).isTransitLeg();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getTrip();
    }

    @Override
    public DataFetcher<Boolean> walkingBike() {
        return environment -> this.getSource(environment).getWalkingBike();
    }

    private Leg getSource(DataFetchingEnvironment environment) {
        return (Leg)environment.getSource();
    }

    @Override
    public DataFetcher<Iterable<Leg>> nextLegs() {
        return environment -> {
            Object patt7331$temp = environment.getSource();
            if (patt7331$temp instanceof ScheduledTransitLeg) {
                ScheduledTransitLeg originalLeg = (ScheduledTransitLeg)patt7331$temp;
                LegacyGraphQLTypes.LegacyGraphQLLegNextLegsArgs args = new LegacyGraphQLTypes.LegacyGraphQLLegNextLegsArgs(environment.getArguments());
                int numberOfLegs = args.getLegacyGraphQLNumberOfLegs();
                List<LegacyGraphQLTypes.LegacyGraphQLTransitMode> originModesWithParentStation = args.getLegacyGraphQLOriginModesWithParentStation();
                List<LegacyGraphQLTypes.LegacyGraphQLTransitMode> destinationModesWithParentStation = args.getLegacyGraphQLDestinationModesWithParentStation();
                boolean limitToExactOriginStop = originModesWithParentStation == null || !originModesWithParentStation.stream().map(Enum::toString).toList().contains(originalLeg.getMode().name());
                boolean limitToExactDestinationStop = destinationModesWithParentStation == null || !destinationModesWithParentStation.stream().map(Enum::toString).toList().contains(originalLeg.getMode().name());
                List<Leg> res = AlternativeLegs.getAlternativeLegs((Leg)environment.getSource(), numberOfLegs, ((LegacyGraphQLRequestContext)environment.getContext()).transitService(), false, AlternativeLegsFilter.NO_FILTER, limitToExactOriginStop, limitToExactDestinationStop).stream().map(Leg.class::cast).toList();
                return res;
            }
            return null;
        };
    }
}

