/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLCauseMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLEffectMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLSeverityMapper;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLRouteTypeModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLStopOnRouteModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLStopOnTripModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLUnknownModel;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;

public class LegacyGraphQLAlertImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLAlert {
    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).entities().stream().filter(EntitySelector.Agency.class::isInstance).findAny().map(EntitySelector.Agency.class::cast).map(entitySelector -> this.getTransitService(environment).getAgencyForId(entitySelector.agencyId())).orElse(null);
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLAlertCauseType> alertCause() {
        return environment -> LegacyGraphQLCauseMapper.getLegacyGraphQLCause(this.getSource(environment).cause());
    }

    @Override
    public DataFetcher<String> alertDescriptionText() {
        return environment -> this.getSource(environment).descriptionText().toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertDescriptionTextTranslations() {
        return environment -> {
            I18NString text = this.getSource(environment).descriptionText();
            return this.getTranslations(text);
        };
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLAlertEffectType> alertEffect() {
        return environment -> LegacyGraphQLEffectMapper.getLegacyGraphQLEffect(this.getSource(environment).effect());
    }

    @Override
    public DataFetcher<Integer> alertHash() {
        return environment -> {
            TransitAlert alert = this.getSource(environment);
            return Objects.hash(new Object[]{alert.descriptionText(), alert.headerText(), alert.url(), alert.cause(), alert.effect(), alert.severity()});
        };
    }

    @Override
    public DataFetcher<String> alertHeaderText() {
        return environment -> GraphQLUtils.getTranslation(this.getSource(environment).headerText(), environment);
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertHeaderTextTranslations() {
        return environment -> {
            I18NString text = this.getSource(environment).headerText();
            return this.getTranslations(text);
        };
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLAlertSeverityLevelType> alertSeverityLevel() {
        return environment -> LegacyGraphQLSeverityMapper.getLegacyGraphQLSeverity(this.getSource(environment).severity());
    }

    @Override
    public DataFetcher<String> alertUrl() {
        return environment -> {
            I18NString alertUrl = this.getSource(environment).url();
            return alertUrl == null ? null : alertUrl.toString(environment.getLocale());
        };
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertUrlTranslations() {
        return environment -> {
            I18NString url = this.getSource(environment).url();
            return this.getTranslations(url);
        };
    }

    @Override
    public DataFetcher<Long> effectiveEndDate() {
        return environment -> {
            Instant effectiveEndDate = this.getSource(environment).getEffectiveEndDate();
            if (effectiveEndDate == null) {
                return null;
            }
            return effectiveEndDate.getEpochSecond();
        };
    }

    @Override
    public DataFetcher<Long> effectiveStartDate() {
        return environment -> {
            Instant effectiveStartDate = this.getSource(environment).getEffectiveStartDate();
            if (effectiveStartDate == null) {
                return null;
            }
            return effectiveStartDate.getEpochSecond();
        };
    }

    @Override
    public DataFetcher<Iterable<Object>> entities() {
        return environment -> this.getSource(environment).entities().stream().map(entitySelector -> {
            if (entitySelector instanceof EntitySelector.Stop) {
                FeedScopedId id = ((EntitySelector.Stop)entitySelector).stopId();
                RegularStop stop = this.getTransitService(environment).getRegularStop(id);
                return List.of(this.getAlertEntityOrUnknown(stop, id.toString(), "stop"));
            }
            if (entitySelector instanceof EntitySelector.Agency) {
                FeedScopedId id = ((EntitySelector.Agency)entitySelector).agencyId();
                Agency agency = this.getTransitService(environment).getAgencyForId(id);
                return List.of(this.getAlertEntityOrUnknown(agency, id.toString(), "agency"));
            }
            if (entitySelector instanceof EntitySelector.Route) {
                FeedScopedId id = ((EntitySelector.Route)entitySelector).routeId();
                Route route = this.getTransitService(environment).getRouteForId(id);
                return List.of(this.getAlertEntityOrUnknown(route, id.toString(), "route"));
            }
            if (entitySelector instanceof EntitySelector.Trip) {
                FeedScopedId id = ((EntitySelector.Trip)entitySelector).tripId();
                Trip trip = this.getTransitService(environment).getTripForId(id);
                return List.of(this.getAlertEntityOrUnknown(trip, id.toString(), "trip"));
            }
            if (entitySelector instanceof EntitySelector.StopAndRoute) {
                EntitySelector.StopAndRoute stopAndRoute = (EntitySelector.StopAndRoute)entitySelector;
                FeedScopedId stopId = stopAndRoute.stopId();
                FeedScopedId routeId = stopAndRoute.routeId();
                RegularStop stop = this.getTransitService(environment).getRegularStop(stopId);
                Route route = this.getTransitService(environment).getRouteForId(routeId);
                return List.of(stop != null && route != null ? new LegacyGraphQLStopOnRouteModel(stop, route) : this.getUnknownForAlertEntityPair(stop, route, stopId.toString(), routeId.toString(), "stop", "route"));
            }
            if (entitySelector instanceof EntitySelector.StopAndTrip) {
                EntitySelector.StopAndTrip stopAndTrip = (EntitySelector.StopAndTrip)entitySelector;
                FeedScopedId stopId = stopAndTrip.stopId();
                FeedScopedId tripId = stopAndTrip.tripId();
                RegularStop stop = this.getTransitService(environment).getRegularStop(stopId);
                Trip trip = this.getTransitService(environment).getTripForId(tripId);
                return List.of(stop != null && trip != null ? new LegacyGraphQLStopOnTripModel(stop, trip) : this.getUnknownForAlertEntityPair(stop, trip, stopId.toString(), tripId.toString(), "stop", "trip"));
            }
            if (entitySelector instanceof EntitySelector.RouteTypeAndAgency) {
                FeedScopedId agencyId = ((EntitySelector.RouteTypeAndAgency)entitySelector).agencyId();
                int routeType = ((EntitySelector.RouteTypeAndAgency)entitySelector).routeType();
                Agency agency = this.getTransitService(environment).getAgencyForId(agencyId);
                return List.of(agency != null ? new LegacyGraphQLRouteTypeModel(agency, routeType, agency.getId().getFeedId()) : this.getUnknownForAlertEntityPair(agency, routeType, null, Integer.toString(routeType), "agency", "route type"));
            }
            if (entitySelector instanceof EntitySelector.RouteType) {
                int routeType = ((EntitySelector.RouteType)entitySelector).routeType();
                String feedId = ((EntitySelector.RouteType)entitySelector).feedId();
                return List.of(new LegacyGraphQLRouteTypeModel(null, routeType, feedId));
            }
            if (entitySelector instanceof EntitySelector.DirectionAndRoute) {
                Direction direction = ((EntitySelector.DirectionAndRoute)entitySelector).direction();
                FeedScopedId routeId = ((EntitySelector.DirectionAndRoute)entitySelector).routeId();
                Route route = this.getTransitService(environment).getRouteForId(routeId);
                return route != null ? this.getTransitService(environment).getPatternsForRoute(route).stream().filter(pattern -> pattern.getDirection() == direction).collect(Collectors.toList()) : List.of(this.getUnknownForAlertEntityPair(route, (Object)direction, null, direction.name(), "route", "direction"));
            }
            if (entitySelector instanceof EntitySelector.Unknown) {
                return List.of(new LegacyGraphQLUnknownModel(((EntitySelector.Unknown)entitySelector).description()));
            }
            return List.of();
        }).flatMap(Collection::stream).map(Object.class::cast).collect(Collectors.toList());
    }

    @Override
    public DataFetcher<String> feed() {
        return environment -> this.getSource(environment).getId().getFeedId();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Alert", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> Collections.emptyList();
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getSource(environment).entities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Route).findAny().map(EntitySelector.Route.class::cast).map(entitySelector -> this.getTransitService(environment).getRouteForId(entitySelector.routeId())).orElse(null);
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource(environment).entities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Stop).findAny().map(EntitySelector.Stop.class::cast).map(entitySelector -> this.getTransitService(environment).getRegularStop(entitySelector.stopId())).orElse(null);
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).entities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Trip).findAny().map(EntitySelector.Trip.class::cast).map(entitySelector -> this.getTransitService(environment).getTripForId(entitySelector.tripId())).orElse(null);
    }

    private Object getAlertEntityOrUnknown(Object entity, String id, String type) {
        if (entity != null) {
            return entity;
        }
        return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s but the %s doesn't exist.", type, id, type));
    }

    private Object getUnknownForAlertEntityPair(Object entityA, Object entityB, String idA, String idB, String typeA, String typeB) {
        if (entityA == null && entityB == null) {
            return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s and %s don't exist.", typeA, idA, typeB, idB, typeA, typeB));
        }
        if (entityA == null) {
            return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s doesn't exist.", typeA, idA, typeB, idB, typeA));
        }
        return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s doesn't exist.", typeA, idA, typeB, idB, typeB));
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).transitService();
    }

    private TransitAlert getSource(DataFetchingEnvironment environment) {
        return (TransitAlert)environment.getSource();
    }

    private Iterable<Map.Entry<String, String>> getTranslations(I18NString text) {
        return text instanceof TranslatedString ? ((TranslatedString)text).getTranslations() : Collections.emptyList();
    }
}

